/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.configuration.TlsProperties;
import org.springframework.core.env.Environment;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

@ConfigurationProperties(value="spring.cloud.config")
public class ConfigClientProperties {
    public static final String PREFIX = "spring.cloud.config";
    public static final String DEFAULT_APPLICATION = "application";
    public static final String NAME_PLACEHOLDER = "${spring.cloud.config.name:${spring.application.name:application}}";
    public static final String CONFIG_DISCOVERY_ENABLED = "spring.cloud.config.discovery.enabled";
    public static final String TOKEN_HEADER = "X-Config-Token";
    public static final String STATE_HEADER = "X-Config-State";
    public static final String AUTHORIZATION = "authorization";
    public static final String DEFAULT_PROFILE = "default";
    private boolean enabled = true;
    private String profile = "default";
    @Value(value="${spring.application.name:application}")
    private String name;
    private String label;
    private String username;
    private String password;
    private String[] uri = new String[]{"http://localhost:8888"};
    private MultipleUriStrategy multipleUriStrategy = MultipleUriStrategy.ALWAYS;
    private String mediaType = "application/vnd.spring-cloud.config-server.v2+json";
    private Charset charset = StandardCharsets.UTF_8;
    private Discovery discovery = new Discovery();
    private TlsProperties tls = new TlsProperties();
    private boolean failFast = false;
    private String token;
    private int requestReadTimeout = 185000;
    private int requestConnectTimeout = 10000;
    private boolean sendState = true;
    private Map<String, String> headers = new HashMap<String, String>();
    private boolean sendAllLabels = false;

    ConfigClientProperties() {
    }

    public ConfigClientProperties(Environment environment) {
        Object[] profiles = environment.getActiveProfiles();
        if (profiles.length == 0) {
            profiles = environment.getDefaultProfiles();
        }
        this.setProfile(StringUtils.arrayToCommaDelimitedString((Object[])profiles));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String[] getUri() {
        return this.uri;
    }

    public void setUri(String[] url) {
        this.uri = url;
    }

    public MultipleUriStrategy getMultipleUriStrategy() {
        return this.multipleUriStrategy;
    }

    public void setMultipleUriStrategy(MultipleUriStrategy multipleUriStrategy) {
        this.multipleUriStrategy = multipleUriStrategy;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String env) {
        this.profile = env;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Credentials getCredentials(int index) {
        return this.extractCredentials(index);
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Discovery getDiscovery() {
        return this.discovery;
    }

    public void setDiscovery(Discovery discovery) {
        this.discovery = discovery;
    }

    public TlsProperties getTls() {
        return this.tls;
    }

    public void setTls(TlsProperties tls) {
        this.tls = tls;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public int getRequestReadTimeout() {
        return this.requestReadTimeout;
    }

    public void setRequestReadTimeout(int requestReadTimeout) {
        this.requestReadTimeout = requestReadTimeout;
    }

    public int getRequestConnectTimeout() {
        return this.requestConnectTimeout;
    }

    public void setRequestConnectTimeout(int requestConnectTimeout) {
        this.requestConnectTimeout = requestConnectTimeout;
    }

    public boolean isSendState() {
        return this.sendState;
    }

    public void setSendState(boolean sendState) {
        this.sendState = sendState;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public boolean isSendAllLabels() {
        return this.sendAllLabels;
    }

    public void setSendAllLabels(boolean sendAllLabels) {
        this.sendAllLabels = sendAllLabels;
    }

    private Credentials extractCredentials(int index) {
        String uri;
        Credentials result = new Credentials();
        int noOfUrl = this.uri.length;
        if (index < 0 || index >= noOfUrl) {
            throw new IllegalStateException("Trying to access an invalid array index");
        }
        result.uri = uri = this.uri[index];
        Credentials explicitCredentials = this.getUsernamePassword();
        result.username = explicitCredentials.username;
        result.password = explicitCredentials.password;
        try {
            URL url = new URL(uri);
            Object userInfo = url.getUserInfo();
            if (ObjectUtils.isEmpty((Object)userInfo) || ":".equals(userInfo)) {
                return result;
            }
            result.uri = UriComponentsBuilder.fromUriString((String)uri, (UriComponentsBuilder.ParserType)UriComponentsBuilder.ParserType.WHAT_WG).userInfo(null).build().toUriString();
            if (!((String)userInfo).contains(":")) {
                userInfo = (String)userInfo + ":";
            }
            int sepIndex = ((String)userInfo).indexOf(":");
            result.username = ((String)userInfo).substring(0, sepIndex);
            result.password = ((String)userInfo).substring(sepIndex + 1);
            if (explicitCredentials.password != null) {
                result.password = explicitCredentials.password;
            }
            if (!"user".equals(explicitCredentials.username)) {
                result.username = explicitCredentials.username;
            }
            result.password = URLDecoder.decode(result.password, StandardCharsets.UTF_8);
            result.username = URLDecoder.decode(result.username, StandardCharsets.UTF_8);
            return result;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid URL: " + uri, e);
        }
    }

    private Credentials getUsernamePassword() {
        Credentials credentials = new Credentials();
        if (StringUtils.hasText((String)this.password)) {
            credentials.password = this.password.trim();
        }
        credentials.username = StringUtils.hasText((String)this.username) ? this.username.trim() : "user";
        return credentials;
    }

    public ConfigClientProperties override(Environment environment) {
        ConfigClientProperties override = new ConfigClientProperties();
        BeanUtils.copyProperties((Object)this, (Object)override);
        override.setName(environment.resolvePlaceholders(NAME_PLACEHOLDER));
        if (environment.containsProperty("spring.cloud.config.profile")) {
            override.setProfile(environment.getProperty("spring.cloud.config.profile"));
        }
        if (environment.containsProperty("spring.cloud.config.label")) {
            override.setLabel(environment.getProperty("spring.cloud.config.label"));
        }
        return override;
    }

    public String toString() {
        return "ConfigClientProperties [enabled=" + this.enabled + ", profile=" + this.profile + ", name=" + this.name + ", label=" + this.label + ", username=" + this.username + ", password=" + this.password + ", uri=" + Arrays.toString(this.uri) + ", mediaType=" + this.mediaType + ", discovery=" + this.discovery + ", failFast=" + this.failFast + ", token=" + this.token + ", requestConnectTimeout=" + this.requestConnectTimeout + ", requestReadTimeout=" + this.requestReadTimeout + ", sendState=" + this.sendState + ", headers=" + this.headers + ", sendAllLabels=" + this.sendAllLabels + "]";
    }

    public static enum MultipleUriStrategy {
        ALWAYS,
        CONNECTION_TIMEOUT_ONLY;

    }

    public static class Discovery {
        public static final String DEFAULT_CONFIG_SERVER = "configserver";
        private boolean enabled;
        private String serviceId = "configserver";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }
    }

    public static class Credentials {
        private String username;
        private String password;
        private String uri;

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

