/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.serviceregistry;

import org.springframework.cloud.client.discovery.AbstractDiscoveryLifecycle;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistration;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;

public abstract class AbstractAutoServiceRegistration<R extends Registration>
extends AbstractDiscoveryLifecycle
implements AutoServiceRegistration {
    private ServiceRegistry<R> serviceRegistry;

    protected AbstractAutoServiceRegistration(ServiceRegistry<R> serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected ServiceRegistry<R> getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected abstract R getRegistration();

    protected abstract R getManagementRegistration();

    @Override
    protected void register() {
        this.serviceRegistry.register(this.getRegistration());
    }

    @Override
    protected void registerManagement() {
        this.serviceRegistry.register(this.getManagementRegistration());
    }

    @Override
    protected void deregister() {
        this.serviceRegistry.deregister(this.getRegistration());
    }

    @Override
    protected void deregisterManagement() {
        this.serviceRegistry.deregister(this.getManagementRegistration());
    }

    @Override
    public void stop() {
        if (this.getRunning().compareAndSet(true, false) && this.isEnabled()) {
            this.deregister();
            if (this.shouldRegisterManagement()) {
                this.deregisterManagement();
            }
            this.serviceRegistry.close();
        }
    }
}

