/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security;

import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.common.security.support.FileSecurityProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.util.Assert;

@Configuration
public class FileAuthenticationConfiguration
extends GlobalAuthenticationConfigurerAdapter {
    @Autowired
    private FileSecurityProperties fileSecurityProperties;

    public void init(AuthenticationManagerBuilder auth) throws Exception {
        Assert.notEmpty((Map)this.fileSecurityProperties.getUsers(), (String)String.format("No user specified. Please specify at least 1 user for the file based authentication.", new Object[0]));
        InMemoryUserDetailsManager inMemory = new InMemoryUserDetailsManager(this.fileSecurityProperties.getUsers());
        auth.userDetailsService((UserDetailsService)inMemory);
    }
}

