/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cluster.redis.lock;

import java.util.concurrent.locks.Lock;
import org.springframework.cloud.cluster.lock.DistributedLock;
import org.springframework.cloud.cluster.lock.LockService;
import org.springframework.cloud.cluster.lock.support.DelegatingDistributedLock;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.integration.redis.util.RedisLockRegistry;

public class RedisLockService
implements LockService {
    public static final String DEFAULT_REGISTRY_KEY = "spring-cloud";
    private final RedisLockRegistry redisLockRegistry;

    public RedisLockService(RedisConnectionFactory connectionFactory) {
        this(connectionFactory, DEFAULT_REGISTRY_KEY);
    }

    public RedisLockService(RedisConnectionFactory connectionFactory, String registryKey) {
        this.redisLockRegistry = new RedisLockRegistry(connectionFactory, registryKey);
    }

    public RedisLockService(RedisConnectionFactory connectionFactory, long expireAfter) {
        this.redisLockRegistry = new RedisLockRegistry(connectionFactory, DEFAULT_REGISTRY_KEY, expireAfter);
    }

    public RedisLockService(RedisConnectionFactory connectionFactory, String registryKey, long expireAfter) {
        this.redisLockRegistry = new RedisLockRegistry(connectionFactory, registryKey, expireAfter);
    }

    public DistributedLock obtain(String lockKey) {
        Lock lock = this.redisLockRegistry.obtain((Object)lockKey);
        return new DelegatingDistributedLock(lockKey, lock);
    }
}

