/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.session;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.filter.OncePerRequestFilter;

@Configuration
@PropertySource(value={"spring-cloud-cloudfoundry.properties"})
public class StickyFilterConfiguration {
    @Value(value="${spring.cloud.cloudfoundry.web.cookie}")
    private String cookie;

    @Bean
    public FilterRegistrationBean<?> stickyCloudFoundryFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setOrder(Integer.MAX_VALUE);
        filter.setFilter((Filter)new OncePerRequestFilter(){

            protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
                if (!response.containsHeader("Set-Cookie")) {
                    response.addCookie(new Cookie("JSESSIONID", StickyFilterConfiguration.this.cookie));
                }
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        });
        return filter;
    }
}

