/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.cloud.cloudfoundry")
public class CloudFoundryProperties
implements InitializingBean {
    @Value(value="${vcap.application.cf_api:api.run.pivotal.io}")
    private String url;
    private String username;
    private String password;
    private String org;
    @Value(value="${vcap.application.space_name:}")
    private String space;
    private boolean skipSslValidation;

    public String getUrl() {
        return this.url;
    }

    private String safeUrl(String t) {
        String group;
        String input = t.trim().toLowerCase();
        Pattern p = Pattern.compile("(http(s)?://)(.*)");
        Matcher matcher = p.matcher(input);
        if (matcher.matches() && StringUtils.hasText((String)(group = matcher.group(1)))) {
            return t.substring(group.length());
        }
        return t;
    }

    public void setUrl(String cloudControllerUrl) {
        this.url = cloudControllerUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String email) {
        this.username = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getOrg() {
        return this.org;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public String getSpace() {
        return this.space;
    }

    public void setSpace(String space) {
        this.space = space;
    }

    public boolean isSkipSslValidation() {
        return this.skipSslValidation;
    }

    public boolean getSkipSslValidation() {
        return this.skipSslValidation;
    }

    public void setSkipSslValidation(boolean skipSslValidation) {
        this.skipSslValidation = skipSslValidation;
    }

    public void afterPropertiesSet() {
        this.url = this.safeUrl(this.url);
        this.password = this.password.trim();
        this.username = this.username.trim();
        if (this.org != null) {
            this.org = this.org.trim();
        }
        if (this.space != null) {
            this.space = this.space.trim();
        }
        HashMap<String, String> vals = new HashMap<String, String>();
        vals.put("url", this.getUrl());
        vals.put("username", this.getUsername());
        vals.put("password", this.getPassword());
        vals.forEach((key, value) -> Assert.hasText((String)value, (String)String.format("'%s' must be provided", key)));
    }
}

