/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.springretry;

import org.springframework.classify.Classifier;
import org.springframework.cloud.client.circuitbreaker.ConfigBuilder;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.retry.policy.CircuitBreakerRetryPolicy;

public class SpringRetryConfigBuilder
implements ConfigBuilder<SpringRetryConfig> {
    private String id;
    private BackOffPolicy backOffPolicy = new NoBackOffPolicy();
    private RetryPolicy retryPolicy = new CircuitBreakerRetryPolicy();
    private boolean forceRefreshState = false;
    private Classifier<Throwable, Boolean> stateClassifier = new Classifier<Throwable, Boolean>(){

        public Boolean classify(Throwable classifiable) {
            return false;
        }
    };

    public SpringRetryConfigBuilder(String id) {
        this.id = id;
    }

    public SpringRetryConfigBuilder backOffPolicy(BackOffPolicy backOffPolicy) {
        this.backOffPolicy = backOffPolicy;
        return this;
    }

    public SpringRetryConfigBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = new CircuitBreakerRetryPolicy(retryPolicy);
        return this;
    }

    public SpringRetryConfigBuilder forceRefreshState(boolean refersh) {
        this.forceRefreshState = this.forceRefreshState;
        return this;
    }

    public SpringRetryConfigBuilder stateClassifier(Classifier<Throwable, Boolean> classifier) {
        this.stateClassifier = classifier;
        return this;
    }

    public SpringRetryConfig build() {
        SpringRetryConfig config = new SpringRetryConfig();
        config.setBackOffPolicy(this.backOffPolicy);
        config.setId(this.id);
        config.setRetryPolicy(this.retryPolicy);
        config.setForceRefreshState(this.forceRefreshState);
        config.setStateClassifier(this.stateClassifier);
        return config;
    }

    public static class SpringRetryConfig {
        private String id;
        private RetryContext retryContext;
        private BackOffPolicy backOffPolicy;
        private RetryPolicy retryPolicy;
        private boolean forceRefreshState;
        private Classifier<Throwable, Boolean> stateClassifier;

        boolean isForceRefreshState() {
            return this.forceRefreshState;
        }

        void setForceRefreshState(boolean forceRefreshState) {
            this.forceRefreshState = forceRefreshState;
        }

        Classifier<Throwable, Boolean> getStateClassifier() {
            return this.stateClassifier;
        }

        void setStateClassifier(Classifier<Throwable, Boolean> stateClassifier) {
            this.stateClassifier = stateClassifier;
        }

        RetryPolicy getRetryPolicy() {
            return this.retryPolicy;
        }

        void setRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
        }

        String getId() {
            return this.id;
        }

        void setId(String id) {
            this.id = id;
        }

        RetryContext getRetryContext() {
            return this.retryContext;
        }

        void setRetryContext(RetryContext retryContext) {
            this.retryContext = retryContext;
        }

        BackOffPolicy getBackOffPolicy() {
            return this.backOffPolicy;
        }

        void setBackOffPolicy(BackOffPolicy backOffPolicy) {
            this.backOffPolicy = backOffPolicy;
        }
    }
}

