/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.springretry;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.cloud.circuitbreaker.springretry.SpringRetryConfigBuilder;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.retry.RetryState;
import org.springframework.retry.support.DefaultRetryState;
import org.springframework.retry.support.RetryTemplate;

public class SpringRetryCircuitBreaker
implements CircuitBreaker {
    private String id;
    private SpringRetryConfigBuilder.SpringRetryConfig config;
    private Optional<Customizer<RetryTemplate>> retryTemplateCustomizer;
    private RetryTemplate retryTemplate;

    public SpringRetryCircuitBreaker(String id, SpringRetryConfigBuilder.SpringRetryConfig config, Optional<Customizer<RetryTemplate>> retryTemplateCustomizer) {
        this.id = id;
        this.config = config;
        this.retryTemplateCustomizer = retryTemplateCustomizer;
        this.retryTemplate = new RetryTemplate();
    }

    public <T> T run(Supplier<T> toRun, Function<Throwable, T> fallback) {
        this.retryTemplate.setBackOffPolicy(this.config.getBackOffPolicy());
        this.retryTemplate.setRetryPolicy(this.config.getRetryPolicy());
        this.retryTemplateCustomizer.ifPresent(customizer -> customizer.customize((Object)this.retryTemplate));
        return (T)this.retryTemplate.execute(context -> toRun.get(), context -> fallback.apply(context.getLastThrowable()), (RetryState)new DefaultRetryState((Object)this.id, this.config.isForceRefreshState(), this.config.getStateClassifier()));
    }
}

