/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus;

import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.bus.BusProperties;
import org.springframework.cloud.bus.ConditionalOnBusEnabled;
import org.springframework.cloud.bus.endpoint.RefreshBusEndpoint;
import org.springframework.cloud.bus.event.RefreshListener;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBusEnabled
@AutoConfigureAfter(name={"org.springframework.cloud.autoconfigure.RefreshAutoConfiguration"})
public class BusRefreshAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"spring.cloud.bus.refresh.enabled"}, matchIfMissing=true)
    @ConditionalOnBean(value={ContextRefresher.class})
    public RefreshListener refreshListener(ContextRefresher contextRefresher) {
        return new RefreshListener(contextRefresher);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={ContextRefresher.class})
    @ConditionalOnClass(name={"org.springframework.boot.actuate.endpoint.annotation.Endpoint", "org.springframework.cloud.context.scope.refresh.RefreshScope"})
    protected static class BusRefreshEndpointConfiguration {
        protected BusRefreshEndpointConfiguration() {
        }

        @Bean
        @ConditionalOnAvailableEndpoint
        public RefreshBusEndpoint refreshBusEndpoint(ApplicationContext context, BusProperties bus) {
            return new RefreshBusEndpoint((ApplicationEventPublisher)context, bus.getId());
        }
    }
}

