/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot;

import java.util.Map;
import org.springframework.cloud.bindings.Bindings;
import org.springframework.cloud.bindings.boot.BindingsPropertiesProcessor;
import org.springframework.cloud.bindings.boot.Guards;
import org.springframework.cloud.bindings.boot.MapMapper;
import org.springframework.core.env.Environment;

final class Neo4JBindingsPropertiesProcessor
implements BindingsPropertiesProcessor {
    public static final String TYPE = "neo4j";

    Neo4JBindingsPropertiesProcessor() {
    }

    @Override
    public void process(Environment environment, Bindings bindings, Map<String, Object> properties) {
        if (!Guards.isTypeEnabled(environment, TYPE)) {
            return;
        }
        bindings.filterBindings(TYPE).forEach(binding -> {
            MapMapper map = new MapMapper(binding.getSecret(), properties);
            map.from("password").to("spring.neo4j.authentication.password");
            map.from("uri").to("spring.neo4j.uri");
            map.from("username").to("spring.neo4j.authentication.username");
        });
    }
}

