/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.config.annotation;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.AmazonSQSAsyncClient;
import com.amazonaws.services.sqs.buffered.AmazonSQSBufferedAsyncClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.aws.context.annotation.ConditionalOnMissingAmazonClient;
import org.springframework.cloud.aws.core.region.RegionProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@ConditionalOnMissingAmazonClient(value=AmazonSQS.class)
public class SqsClientConfiguration {
    @Autowired(required=false)
    private AWSCredentialsProvider awsCredentialsProvider;
    @Autowired(required=false)
    private RegionProvider regionProvider;

    @Lazy
    @Bean(destroyMethod="shutdown")
    public AmazonSQSAsync amazonSQS() {
        AmazonSQSAsyncClient amazonSQSAsyncClient = this.awsCredentialsProvider != null ? new AmazonSQSAsyncClient(this.awsCredentialsProvider) : new AmazonSQSAsyncClient();
        if (this.regionProvider != null) {
            amazonSQSAsyncClient.setRegion(this.regionProvider.getRegion());
        }
        return new AmazonSQSBufferedAsyncClient((AmazonSQSAsync)amazonSQSAsyncClient);
    }
}

