/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.listener;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.cloud.aws.messaging.support.NotificationMessageArgumentResolver;
import org.springframework.cloud.aws.messaging.support.NotificationSubjectArgumentResolver;
import org.springframework.cloud.aws.messaging.support.converter.ObjectMessageConverter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SimpleMessageConverter;
import org.springframework.messaging.handler.HandlerMethod;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.support.AnnotationExceptionHandlerMethodResolver;
import org.springframework.messaging.handler.annotation.support.HeaderMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeadersMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.PayloadArgumentResolver;
import org.springframework.messaging.handler.invocation.AbstractExceptionHandlerMethodResolver;
import org.springframework.messaging.handler.invocation.AbstractMethodMessageHandler;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.util.ClassUtils;
import org.springframework.util.comparator.ComparableComparator;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class QueueMessageHandler
extends AbstractMethodMessageHandler<MappingInformation> {
    private static final boolean JACKSON_2_PRESENT = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)QueueMessageHandler.class.getClassLoader());

    protected List<? extends HandlerMethodArgumentResolver> initArgumentResolvers() {
        ArrayList<Object> resolvers = new ArrayList<Object>();
        resolvers.addAll(this.getCustomArgumentResolvers());
        resolvers.add(new HeaderMethodArgumentResolver(null, null));
        resolvers.add(new HeadersMethodArgumentResolver());
        resolvers.add(new NotificationMessageArgumentResolver());
        resolvers.add(new NotificationSubjectArgumentResolver());
        CompositeMessageConverter compositeMessageConverter = this.createPayloadArgumentCompositeConverter();
        resolvers.add(new PayloadArgumentResolver((MessageConverter)compositeMessageConverter, (Validator)new NoOpValidator()));
        return resolvers;
    }

    protected List<? extends HandlerMethodReturnValueHandler> initReturnValueHandlers() {
        ArrayList handlers = new ArrayList();
        handlers.addAll(this.getCustomReturnValueHandlers());
        return handlers;
    }

    protected boolean isHandler(Class<?> beanType) {
        return true;
    }

    protected MappingInformation getMappingForMethod(Method method, Class<?> handlerType) {
        MessageMapping messageMappingAnnotation = (MessageMapping)AnnotationUtils.findAnnotation((Method)method, MessageMapping.class);
        if (messageMappingAnnotation == null) {
            return null;
        }
        if (messageMappingAnnotation.value().length < 1) {
            throw new IllegalStateException("@MessageMapping annotation must have at least one destination");
        }
        HashSet<String> logicalResourceIds = new HashSet<String>(messageMappingAnnotation.value().length);
        logicalResourceIds.addAll(Arrays.asList(messageMappingAnnotation.value()));
        return new MappingInformation(logicalResourceIds);
    }

    protected Set<String> getDirectLookupDestinations(MappingInformation mapping) {
        return mapping.getLogicalResourceIds();
    }

    protected String getDestination(Message<?> message) {
        return message.getHeaders().get((Object)"LogicalResourceId").toString();
    }

    protected MappingInformation getMatchingMapping(MappingInformation mapping, Message<?> message) {
        if (mapping.getLogicalResourceIds().contains(this.getDestination(message))) {
            return mapping;
        }
        return null;
    }

    protected Comparator<MappingInformation> getMappingComparator(Message<?> message) {
        return new ComparableComparator();
    }

    protected AbstractExceptionHandlerMethodResolver createExceptionHandlerMethodResolverFor(Class<?> beanType) {
        return new AnnotationExceptionHandlerMethodResolver(beanType);
    }

    protected void handleNoMatch(Set<MappingInformation> ts, String lookupDestination, Message<?> message) {
        this.logger.warn((Object)"No match found");
    }

    protected void processHandlerMethodException(HandlerMethod handlerMethod, Exception ex, Message<?> message) {
        super.processHandlerMethodException(handlerMethod, ex, message);
        throw new MessagingException("An exception occurred while invoking the handler method", (Throwable)ex);
    }

    private CompositeMessageConverter createPayloadArgumentCompositeConverter() {
        ArrayList<Object> payloadArgumentConverters = new ArrayList<Object>();
        if (JACKSON_2_PRESENT) {
            MappingJackson2MessageConverter jacksonMessageConverter = new MappingJackson2MessageConverter();
            jacksonMessageConverter.setSerializedPayloadClass(String.class);
            jacksonMessageConverter.setStrictContentTypeMatch(true);
            payloadArgumentConverters.add(jacksonMessageConverter);
        }
        ObjectMessageConverter objectMessageConverter = new ObjectMessageConverter();
        objectMessageConverter.setStrictContentTypeMatch(true);
        payloadArgumentConverters.add((Object)objectMessageConverter);
        payloadArgumentConverters.add(new SimpleMessageConverter());
        return new CompositeMessageConverter(payloadArgumentConverters);
    }

    public static final class Headers {
        public static final String LOGICAL_RESOURCE_ID_MESSAGE_HEADER_KEY = "LogicalResourceId";

        private Headers() {
        }
    }

    private static final class NoOpValidator
    implements Validator {
        private NoOpValidator() {
        }

        public boolean supports(Class<?> clazz) {
            return false;
        }

        public void validate(Object target, Errors errors) {
        }
    }

    protected static class MappingInformation
    implements Comparable<MappingInformation> {
        private final Set<String> logicalResourceIds;

        public MappingInformation(Set<String> logicalResourceIds) {
            this.logicalResourceIds = Collections.unmodifiableSet(logicalResourceIds);
        }

        public Set<String> getLogicalResourceIds() {
            return this.logicalResourceIds;
        }

        @Override
        public int compareTo(MappingInformation o) {
            return 0;
        }
    }
}

