/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.config;

import com.amazonaws.services.sqs.AmazonSQS;
import java.util.List;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.cloud.aws.messaging.core.QueueMessagingTemplate;
import org.springframework.cloud.aws.messaging.listener.QueueMessageHandler;
import org.springframework.cloud.aws.messaging.listener.SendToHandlerMethodReturnValueHandler;
import org.springframework.messaging.core.DestinationResolvingMessageSendingOperations;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.util.CollectionUtils;

public class QueueMessageHandlerFactory {
    private List<HandlerMethodArgumentResolver> argumentResolvers;
    private List<HandlerMethodReturnValueHandler> returnValueHandlers;
    private DestinationResolvingMessageSendingOperations<?> sendToMessagingTemplate;
    private AmazonSQS amazonSqs;
    private ResourceIdResolver resourceIdResolver;

    public void setArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        this.argumentResolvers = argumentResolvers;
    }

    public void setReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
        this.returnValueHandlers = returnValueHandlers;
    }

    public void setSendToMessagingTemplate(DestinationResolvingMessageSendingOperations<?> sendToMessagingTemplate) {
        this.sendToMessagingTemplate = sendToMessagingTemplate;
    }

    public void setAmazonSqs(AmazonSQS amazonSqs) {
        this.amazonSqs = amazonSqs;
    }

    public AmazonSQS getAmazonSqs() {
        return this.amazonSqs;
    }

    public void setResourceIdResolver(ResourceIdResolver resourceIdResolver) {
        this.resourceIdResolver = resourceIdResolver;
    }

    public QueueMessageHandler createQueueMessageHandler() {
        QueueMessageHandler queueMessageHandler = new QueueMessageHandler();
        if (!CollectionUtils.isEmpty(this.argumentResolvers)) {
            queueMessageHandler.getCustomArgumentResolvers().addAll(this.argumentResolvers);
        }
        if (!CollectionUtils.isEmpty(this.returnValueHandlers)) {
            queueMessageHandler.getCustomReturnValueHandlers().addAll(this.returnValueHandlers);
        }
        if (this.sendToMessagingTemplate != null) {
            queueMessageHandler.getCustomReturnValueHandlers().add(new SendToHandlerMethodReturnValueHandler(this.sendToMessagingTemplate));
        } else {
            queueMessageHandler.getCustomReturnValueHandlers().add(new SendToHandlerMethodReturnValueHandler(this.getDefaultSendToQueueMessagingTemplate(this.amazonSqs, this.resourceIdResolver)));
        }
        return queueMessageHandler;
    }

    private QueueMessagingTemplate getDefaultSendToQueueMessagingTemplate(AmazonSQS amazonSqs, ResourceIdResolver resourceIdResolver) {
        return new QueueMessagingTemplate(amazonSqs, resourceIdResolver);
    }
}

