/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.jdbc.retry;

import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.DBInstance;
import com.amazonaws.services.rds.model.DBInstanceNotFoundException;
import com.amazonaws.services.rds.model.DescribeDBInstancesRequest;
import com.amazonaws.services.rds.model.DescribeDBInstancesResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.cloud.aws.jdbc.retry.InstanceStatus;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.context.RetryContextSupport;
import org.springframework.util.Assert;

public class DatabaseInstanceStatusRetryPolicy
implements RetryPolicy {
    private static final String DB_INSTANCE_ATTRIBUTE_NAME = "DbInstanceIdentifier";
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseInstanceStatusRetryPolicy.class);
    private final String dbInstanceIdentifier;
    private final AmazonRDS amazonRDS;
    private ResourceIdResolver resourceIdResolver;

    public DatabaseInstanceStatusRetryPolicy(AmazonRDS amazonRDS, String dbInstanceIdentifier) {
        Assert.notNull((Object)amazonRDS, (String)"amazonRDS must not be null.");
        this.amazonRDS = amazonRDS;
        this.dbInstanceIdentifier = dbInstanceIdentifier;
    }

    public void setResourceIdResolver(ResourceIdResolver resourceIdResolver) {
        this.resourceIdResolver = resourceIdResolver;
    }

    public boolean canRetry(RetryContext context) {
        return context.getLastThrowable() == null || this.isDatabaseAvailable(context);
    }

    public RetryContext open(RetryContext parent) {
        RetryContextSupport context = new RetryContextSupport(parent);
        context.setAttribute(DB_INSTANCE_ATTRIBUTE_NAME, (Object)this.getDbInstanceIdentifier());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Starting RetryContext for database instance with identifier {}", (Object)this.getDbInstanceIdentifier());
        }
        return context;
    }

    public void close(RetryContext context) {
        context.removeAttribute(DB_INSTANCE_ATTRIBUTE_NAME);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Closing RetryContext for database instance with identifier {}", (Object)this.getDbInstanceIdentifier());
        }
    }

    public void registerThrowable(RetryContext context, Throwable throwable) {
        ((RetryContextSupport)context).registerThrowable(throwable);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Registered Throwable of Type {} for RetryContext", (Object)throwable.getClass().getName());
        }
    }

    private boolean isDatabaseAvailable(RetryContext context) {
        DescribeDBInstancesResult describeDBInstancesResult;
        try {
            describeDBInstancesResult = this.amazonRDS.describeDBInstances(new DescribeDBInstancesRequest().withDBInstanceIdentifier((String)context.getAttribute(DB_INSTANCE_ATTRIBUTE_NAME)));
        }
        catch (DBInstanceNotFoundException e) {
            LOGGER.warn("Database Instance with name {} has been removed or is not configured correctly, no retry possible", (Object)this.getDbInstanceIdentifier());
            return false;
        }
        if (describeDBInstancesResult.getDBInstances().size() == 1) {
            DBInstance dbInstance = (DBInstance)describeDBInstancesResult.getDBInstances().get(0);
            InstanceStatus instanceStatus = InstanceStatus.fromDatabaseStatus(dbInstance.getDBInstanceStatus());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Status of database to be retried is {}", (Object)instanceStatus);
            }
            return instanceStatus.isRetryable();
        }
        throw new IllegalStateException("Multiple databases found for same identifier, this is likely an incompatibility with the Amazon SDK");
    }

    private String getDbInstanceIdentifier() {
        return this.resourceIdResolver != null ? this.resourceIdResolver.resolveToPhysicalResourceId(this.dbInstanceIdentifier) : this.dbInstanceIdentifier;
    }
}

