/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.context.config.support;

import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.cloud.aws.core.config.AmazonWebserviceClientConfigurationUtils;
import org.springframework.cloud.aws.core.credentials.CredentialsProviderFactoryBean;
import org.springframework.cloud.aws.core.region.Ec2MetadataRegionProvider;
import org.springframework.cloud.aws.core.region.StaticRegionProvider;
import org.springframework.util.StringUtils;

public final class ContextConfigurationUtils {
    public static final String REGION_PROVIDER_BEAN_NAME = "regionProvider";
    private static final String POST_PROCESSOR_CLASS_NAME = "org.springframework.cloud.aws.context.config.AmazonEc2InstanceDataPropertySourcePostProcessor";
    private static final String POST_PROCESSOR_BEAN_NAME = "AmazonEc2InstanceDataPropertySourcePostProcessor";

    private ContextConfigurationUtils() {
    }

    public static void registerRegionProvider(BeanDefinitionRegistry registry, boolean autoDetect, String configuredRegion) {
        AbstractBeanDefinition beanDefinition;
        if (autoDetect && StringUtils.hasText((String)configuredRegion)) {
            throw new IllegalArgumentException("No region must be configured if autoDetect is defined as true");
        }
        if (autoDetect) {
            beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(Ec2MetadataRegionProvider.class).getBeanDefinition();
        } else if (StringUtils.hasText((String)configuredRegion)) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(StaticRegionProvider.class);
            builder.addConstructorArgValue((Object)configuredRegion);
            beanDefinition = builder.getBeanDefinition();
        } else {
            throw new IllegalArgumentException("Region must be manually configured or autoDetect enabled");
        }
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)new BeanDefinitionHolder((BeanDefinition)beanDefinition, REGION_PROVIDER_BEAN_NAME), (BeanDefinitionRegistry)registry);
        AmazonWebserviceClientConfigurationUtils.replaceDefaultRegionProvider((BeanDefinitionRegistry)registry, (String)REGION_PROVIDER_BEAN_NAME);
    }

    public static void registerDefaultAWSCredentialsProvider(BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(DefaultAWSCredentialsProviderChain.class);
        registry.registerBeanDefinition("credentialsProvider", (BeanDefinition)builder.getBeanDefinition());
        AmazonWebserviceClientConfigurationUtils.replaceDefaultCredentialsProvider((BeanDefinitionRegistry)registry, (String)"credentialsProvider");
    }

    public static void registerCredentialsProvider(BeanDefinitionRegistry registry, String accessKey, String secretKey, boolean instanceProfile, String profileName, String profilePath) {
        BeanDefinitionBuilder factoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(CredentialsProviderFactoryBean.class);
        ManagedList awsCredentialsProviders = new ManagedList();
        if (StringUtils.hasText((String)accessKey)) {
            BeanDefinitionBuilder credentials = BeanDefinitionBuilder.rootBeanDefinition(BasicAWSCredentials.class);
            credentials.addConstructorArgValue((Object)accessKey);
            credentials.addConstructorArgValue((Object)secretKey);
            BeanDefinitionBuilder provider = BeanDefinitionBuilder.rootBeanDefinition(AWSStaticCredentialsProvider.class);
            provider.addConstructorArgValue((Object)credentials.getBeanDefinition());
            awsCredentialsProviders.add((Object)provider.getBeanDefinition());
        }
        if (instanceProfile) {
            awsCredentialsProviders.add((Object)BeanDefinitionBuilder.rootBeanDefinition(EC2ContainerCredentialsProviderWrapper.class).getBeanDefinition());
        }
        if (StringUtils.hasText((String)profileName)) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ProfileCredentialsProvider.class);
            if (StringUtils.hasText((String)profilePath)) {
                builder.addConstructorArgValue((Object)profilePath);
            }
            builder.addConstructorArgValue((Object)profileName);
            awsCredentialsProviders.add((Object)builder.getBeanDefinition());
        }
        factoryBeanBuilder.addConstructorArgValue((Object)awsCredentialsProviders);
        registry.registerBeanDefinition("credentialsProvider", (BeanDefinition)factoryBeanBuilder.getBeanDefinition());
        AmazonWebserviceClientConfigurationUtils.replaceDefaultCredentialsProvider((BeanDefinitionRegistry)registry, (String)"credentialsProvider");
    }

    public static void registerInstanceDataPropertySource(BeanDefinitionRegistry registry, String valueSeparator, String attributeSeparator) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)POST_PROCESSOR_CLASS_NAME);
        builder.addPropertyValue("valueSeparator", (Object)valueSeparator);
        builder.addPropertyValue("attributeSeparator", (Object)attributeSeparator);
        registry.registerBeanDefinition(POST_PROCESSOR_BEAN_NAME, (BeanDefinition)builder.getBeanDefinition());
    }
}

