/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.context.config.xml;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.cloud.aws.core.config.xml.XmlWebserviceConfigurationUtils;
import org.springframework.core.Conventions;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ContextResourceLoaderBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    private static final String RESOURCE_LOADER_CLASS_NAME = "org.springframework.cloud.aws.core.io.s3.SimpleStorageResourceLoader";
    private static final String RESOURCE_RESOLVER_CLASS_NAME = "org.springframework.cloud.aws.core.io.s3.PathMatchingSimpleStorageResourcePatternResolver";
    private static final String AMAZON_S3_CLIENT_CLASS_NAME = "com.amazonaws.services.s3.AmazonS3Client";
    private static final String RESOURCE_LOADER_BEAN_POST_PROCESSOR = "org.springframework.cloud.aws.context.support.io.ResourceLoaderBeanPostProcessor";

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.addConstructorArgReference(XmlWebserviceConfigurationUtils.getCustomClientOrDefaultClientBeanName((Element)element, (ParserContext)parserContext, (String)"amazon-s3", (String)AMAZON_S3_CLIENT_CLASS_NAME));
        builder.addConstructorArgValue((Object)ContextResourceLoaderBeanDefinitionParser.getResourceLoaderBeanDefinition(element, parserContext));
        ContextResourceLoaderBeanDefinitionParser.registerPostProcessor(parserContext);
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        return RESOURCE_RESOLVER_CLASS_NAME;
    }

    protected String getBeanClassName(Element element) {
        return RESOURCE_RESOLVER_CLASS_NAME;
    }

    private static BeanDefinition getResourceLoaderBeanDefinition(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)RESOURCE_LOADER_CLASS_NAME);
        builder.addConstructorArgReference(XmlWebserviceConfigurationUtils.getCustomClientOrDefaultClientBeanName((Element)element, (ParserContext)parserContext, (String)"amazon-s3", (String)AMAZON_S3_CLIENT_CLASS_NAME));
        if (StringUtils.hasText((String)element.getAttribute("task-executor"))) {
            builder.addPropertyReference(Conventions.attributeNameToPropertyName((String)"task-executor"), element.getAttribute("task-executor"));
        }
        return builder.getBeanDefinition();
    }

    private static void registerPostProcessor(ParserContext parserContext) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)RESOURCE_LOADER_BEAN_POST_PROCESSOR);
        beanDefinitionBuilder.addConstructorArgReference(RESOURCE_RESOLVER_CLASS_NAME);
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)beanDefinitionBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
    }
}

