/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.logging.recent;

import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.applications.GetApplicationRequest;
import org.cloudfoundry.doppler.DopplerClient;
import org.cloudfoundry.doppler.RecentLogsRequest;
import org.cloudfoundry.dropsonde.events.Envelope;
import org.springframework.cloud.appbroker.logging.ApplicationIdsProvider;
import org.springframework.cloud.appbroker.logging.LoggingUtils;
import org.springframework.cloud.appbroker.logging.recent.RecentLogsProvider;
import reactor.core.publisher.Flux;

public class ApplicationRecentLogsProvider
implements RecentLogsProvider {
    private final CloudFoundryClient client;
    private final DopplerClient dopplerClient;
    private final ApplicationIdsProvider applicationIdsProvider;

    public ApplicationRecentLogsProvider(CloudFoundryClient client, DopplerClient dopplerClient, ApplicationIdsProvider applicationIdsProvider) {
        this.client = client;
        this.dopplerClient = dopplerClient;
        this.applicationIdsProvider = applicationIdsProvider;
    }

    @Override
    public Flux<Envelope> getLogs(String serviceInstanceId) {
        return this.applicationIdsProvider.getApplicationIds(serviceInstanceId).flatMap(this::recentLogs).map(LoggingUtils::convertDopplerEnvelopeToDropsonde);
    }

    protected Flux<org.cloudfoundry.doppler.Envelope> recentLogs(String applicationId) {
        return this.client.applicationsV2().get(GetApplicationRequest.builder().applicationId(applicationId).build()).map(response -> response.getEntity().getName()).flatMapMany(appName -> this.dopplerClient.recentLogs(RecentLogsRequest.builder().applicationId(applicationId).build()).map(envelope -> LoggingUtils.injectAppNameIntoLogSourceInstance(appName, envelope)));
    }
}

