/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.deployer.manager;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class StartApplicationRequest {
    private final String name;
    private final Map<String, String> properties;

    protected StartApplicationRequest(String name, Map<String, String> properties) {
        this.name = name;
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static StartApplicationRequestBuilder builder() {
        return new StartApplicationRequestBuilder();
    }

    public static final class StartApplicationRequestBuilder {
        private String name;
        private final Map<String, String> properties = new HashMap<String, String>();

        private StartApplicationRequestBuilder() {
        }

        public StartApplicationRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public StartApplicationRequestBuilder properties(Map<String, String> properties) {
            if (!CollectionUtils.isEmpty(properties)) {
                this.properties.putAll(properties);
            }
            return this;
        }

        public StartApplicationRequest build() {
            return new StartApplicationRequest(this.name, this.properties);
        }
    }
}

