/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.autoconfigure;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.appbroker.autoconfigure.AppBrokerAutoConfiguration;
import org.springframework.cloud.appbroker.extensions.credentials.CredHubCredentialsGenerator;
import org.springframework.cloud.appbroker.service.CreateServiceInstanceAppBindingWorkflow;
import org.springframework.cloud.appbroker.service.DeleteServiceInstanceBindingWorkflow;
import org.springframework.cloud.appbroker.workflow.binding.CredHubPersistingCreateServiceInstanceAppBindingWorkflow;
import org.springframework.cloud.appbroker.workflow.binding.CredHubPersistingDeleteServiceInstanceBindingWorkflow;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.credhub.autoconfig.CredHubTemplateAutoConfiguration;
import org.springframework.credhub.core.ReactiveCredHubOperations;

@Configuration
@AutoConfigureBefore(value={AppBrokerAutoConfiguration.class})
@AutoConfigureAfter(value={CredHubTemplateAutoConfiguration.class})
@ConditionalOnClass(value={ReactiveCredHubOperations.class})
@ConditionalOnBean(value={ReactiveCredHubOperations.class})
public class CredHubAutoConfiguration {
    @Value(value="${spring.application.name}")
    private String appName;

    @Bean
    public CreateServiceInstanceAppBindingWorkflow credhubPersistingCreateServiceInstanceAppBindingWorkflow(ReactiveCredHubOperations credHubOperations) {
        return new CredHubPersistingCreateServiceInstanceAppBindingWorkflow(credHubOperations, this.appName);
    }

    @Bean
    public DeleteServiceInstanceBindingWorkflow credhubPersistingDeleteServiceInstanceAppBindingWorkflow(ReactiveCredHubOperations credHubOperations) {
        return new CredHubPersistingDeleteServiceInstanceBindingWorkflow(credHubOperations, this.appName);
    }

    @Bean
    public CredHubCredentialsGenerator credHubCredentialsGenerator(ReactiveCredHubOperations credHubOperations) {
        return new CredHubCredentialsGenerator(credHubOperations);
    }
}

