/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.autoconfigure;

import java.util.HashMap;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.doppler.DopplerClient;
import org.cloudfoundry.doppler.Envelope;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.appbroker.logging.ApplicationIdsProvider;
import org.springframework.cloud.appbroker.logging.streaming.ApplicationLogStreamPublisher;
import org.springframework.cloud.appbroker.logging.streaming.DopplerLogStreamPublisher;
import org.springframework.cloud.appbroker.logging.streaming.LogStreamPublisher;
import org.springframework.cloud.appbroker.logging.streaming.endpoint.StreamingLogWebSocketHandler;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.socket.server.support.WebSocketHandlerAdapter;

@Configuration
@ConditionalOnClass(value={ApplicationLogStreamPublisher.class})
@ConditionalOnBean(value={ApplicationIdsProvider.class})
public class ServiceInstanceLogStreamAutoConfiguration {
    @Bean
    public StreamingLogWebSocketHandler streamingLogWebSocketHandler(ApplicationEventPublisher applicationEventPublisher) {
        return new StreamingLogWebSocketHandler(applicationEventPublisher);
    }

    @Bean
    @ConditionalOnMissingBean
    public WebSocketHandlerAdapter handlerAdapter() {
        return new WebSocketHandlerAdapter();
    }

    @Bean
    public HandlerMapping logsHandlerMapping(StreamingLogWebSocketHandler webSocketHandler) {
        HashMap<String, StreamingLogWebSocketHandler> map = new HashMap<String, StreamingLogWebSocketHandler>();
        map.put("/logs/**/stream", webSocketHandler);
        SimpleUrlHandlerMapping handlerMapping = new SimpleUrlHandlerMapping();
        handlerMapping.setOrder(1);
        handlerMapping.setUrlMap(map);
        return handlerMapping;
    }

    @Bean
    @ConditionalOnMissingBean
    public LogStreamPublisher<Envelope> streamLogsPublisher(CloudFoundryClient cloudFoundryClient, DopplerClient dopplerClient, ApplicationIdsProvider applicationIdsProvider) {
        return new DopplerLogStreamPublisher(cloudFoundryClient, dopplerClient, applicationIdsProvider);
    }

    @Bean
    public ApplicationLogStreamPublisher applicationLogsPublisher(LogStreamPublisher<Envelope> logStreamPublisher, ApplicationEventPublisher eventPublisher) {
        return new ApplicationLogStreamPublisher(logStreamPublisher, eventPublisher);
    }
}

