/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.datasource.converter;

import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.slots.block.AbstractRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.alibaba.sentinel.datasource.RuleType;
import org.springframework.util.StringUtils;

public abstract class SentinelConverter<T extends AbstractRule>
implements Converter<String, List<AbstractRule>> {
    private static final Logger log = LoggerFactory.getLogger(SentinelConverter.class);
    private final ObjectMapper objectMapper;
    private final Class<T> ruleClass;

    public SentinelConverter(ObjectMapper objectMapper, Class<T> ruleClass) {
        this.objectMapper = objectMapper;
        this.ruleClass = ruleClass;
    }

    public List<AbstractRule> convert(String source) {
        ArrayList<AbstractRule> ruleList = new ArrayList<AbstractRule>();
        if (StringUtils.isEmpty((Object)source)) {
            log.warn("converter can not convert rules because source is empty");
            return ruleList;
        }
        try {
            List sourceArray = (List)this.objectMapper.readValue(source, (TypeReference)new TypeReference<List<HashMap>>(){});
            sourceArray.stream().forEach(obj -> {
                String item = null;
                try {
                    item = this.objectMapper.writeValueAsString(obj);
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
                Optional.ofNullable(this.convertRule(item)).ifPresent(convertRule -> ruleList.add((AbstractRule)convertRule));
            });
            if (ruleList.size() != sourceArray.size()) {
                throw new IllegalArgumentException("convert " + ruleList.size() + " rules but there are " + sourceArray.size() + " rules from datasource. RuleClass: " + this.ruleClass.getSimpleName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("convert error: " + e.getMessage(), e);
        }
        return ruleList;
    }

    private AbstractRule convertRule(String ruleStr) {
        try {
            AbstractRule rule = (AbstractRule)this.objectMapper.readValue(ruleStr, this.ruleClass);
            RuleType ruleType = RuleType.getByClass(this.ruleClass).get();
            switch (ruleType) {
                case FLOW: {
                    if (FlowRuleUtil.isValidRule((FlowRule)((FlowRule)rule))) break;
                    return null;
                }
                case DEGRADE: {
                    if (DegradeRuleManager.isValidRule((DegradeRule)((DegradeRule)rule))) break;
                    return null;
                }
            }
            return rule;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

