/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.seata.rest;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.alibaba.seata.rest.SeataRestTemplateInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;

@Configuration
public class SeataRestTemplateAutoConfiguration {
    @Autowired(required=false)
    private Collection<RestTemplate> restTemplates;
    @Autowired
    private SeataRestTemplateInterceptor seataRestTemplateInterceptor;

    @Bean
    public SeataRestTemplateInterceptor fescarRestTemplateInterceptor() {
        return new SeataRestTemplateInterceptor();
    }

    @PostConstruct
    public void init() {
        if (this.restTemplates != null) {
            for (RestTemplate restTemplate : this.restTemplates) {
                ArrayList<SeataRestTemplateInterceptor> interceptors = new ArrayList<SeataRestTemplateInterceptor>(restTemplate.getInterceptors());
                interceptors.add(this.seataRestTemplateInterceptor);
                restTemplate.setInterceptors(interceptors);
            }
        }
    }
}

