/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.seata.feign;

import feign.Client;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.alibaba.seata.feign.SeataFeignObjectWrapper;
import org.springframework.cloud.openfeign.FeignContext;

public class SeataFeignContext
extends FeignContext {
    private final SeataFeignObjectWrapper seataFeignObjectWrapper;
    private final FeignContext delegate;

    SeataFeignContext(SeataFeignObjectWrapper seataFeignObjectWrapper, FeignContext delegate) {
        this.seataFeignObjectWrapper = seataFeignObjectWrapper;
        this.delegate = delegate;
    }

    public <T> T getInstance(String name, Class<T> type) {
        Object object = this.delegate.getInstance(name, type);
        if (object instanceof Client) {
            return (T)object;
        }
        return (T)this.seataFeignObjectWrapper.wrap(object);
    }

    public <T> Map<String, T> getInstances(String name, Class<T> type) {
        Map instances = this.delegate.getInstances(name, type);
        if (instances == null) {
            return null;
        }
        HashMap convertedInstances = new HashMap();
        for (Map.Entry entry : instances.entrySet()) {
            if (entry.getValue() instanceof Client) {
                convertedInstances.put(entry.getKey(), entry.getValue());
                continue;
            }
            convertedInstances.put(entry.getKey(), this.seataFeignObjectWrapper.wrap(entry.getValue()));
        }
        return convertedInstances;
    }
}

