/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.seata.feign;

import feign.Client;
import feign.Feign;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.alibaba.seata.feign.SeataBeanPostProcessor;
import org.springframework.cloud.alibaba.seata.feign.SeataContextBeanPostProcessor;
import org.springframework.cloud.alibaba.seata.feign.SeataFeignBuilder;
import org.springframework.cloud.alibaba.seata.feign.SeataFeignObjectWrapper;
import org.springframework.cloud.alibaba.seata.feign.SeataHystrixFeignBuilder;
import org.springframework.cloud.alibaba.seata.feign.SeataSentinelFeignBuilder;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@ConditionalOnClass(value={Client.class})
@AutoConfigureBefore(value={FeignAutoConfiguration.class})
public class SeataFeignClientAutoConfiguration {
    @Bean
    @Scope(value="prototype")
    @ConditionalOnClass(name={"com.netflix.hystrix.HystrixCommand"})
    @ConditionalOnProperty(name={"feign.hystrix.enabled"}, havingValue="true")
    Feign.Builder feignHystrixBuilder(BeanFactory beanFactory) {
        return SeataHystrixFeignBuilder.builder(beanFactory);
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnClass(name={"com.alibaba.csp.sentinel.SphU"})
    @ConditionalOnProperty(name={"feign.sentinel.enabled"}, havingValue="true")
    Feign.Builder feignSentinelBuilder(BeanFactory beanFactory) {
        return SeataSentinelFeignBuilder.builder(beanFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    @Scope(value="prototype")
    Feign.Builder feignBuilder(BeanFactory beanFactory) {
        return SeataFeignBuilder.builder(beanFactory);
    }

    @Configuration
    protected static class FeignBeanPostProcessorConfiguration {
        protected FeignBeanPostProcessorConfiguration() {
        }

        @Bean
        SeataBeanPostProcessor fescarBeanPostProcessor(SeataFeignObjectWrapper seataFeignObjectWrapper) {
            return new SeataBeanPostProcessor(seataFeignObjectWrapper);
        }

        @Bean
        SeataContextBeanPostProcessor fescarContextBeanPostProcessor(BeanFactory beanFactory) {
            return new SeataContextBeanPostProcessor(beanFactory);
        }

        @Bean
        SeataFeignObjectWrapper fescarFeignObjectWrapper(BeanFactory beanFactory) {
            return new SeataFeignObjectWrapper(beanFactory);
        }
    }
}

