/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.sample;

import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.route.builder.RouteLocatorBuilder;
import org.springframework.cloud.gateway.sample.MyServiceConf;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient;
import org.springframework.context.annotation.Bean;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@SpringBootConfiguration
@EnableAutoConfiguration
@RestController
@LoadBalancerClient(name="myservice", configuration={MyServiceConf.class})
public class MvcFailureAnalyzerApplication {
    @GetMapping(value={"hello"})
    public String hello() {
        return "Hello";
    }

    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public RouteLocator myRouteLocator(RouteLocatorBuilder builder) {
        return builder.routes().route(r -> r.path(new String[]{"/myprefix/**"}).filters(f -> f.stripPrefix(1)).uri("lb://myservice")).build();
    }
}

