/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.launcher.deployer;

import java.util.HashMap;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.deployer.resource.maven.MavenProperties;
import org.springframework.cloud.deployer.resource.maven.MavenResourceLoader;
import org.springframework.cloud.deployer.resource.support.DelegatingResourceLoader;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.launcher.deployer.Deployer;
import org.springframework.cloud.launcher.deployer.DeployerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ResourceLoader;

@Configuration
@EnableAutoConfiguration
@EnableConfigurationProperties(value={DeployerProperties.class})
public class DeployerConfiguration {
    @Bean
    public Deployer deployer(AppDeployer deployer, MavenResourceLoader resourceLoader, DeployerProperties properties, ConfigurableEnvironment environment) {
        return new Deployer(deployer, (ResourceLoader)resourceLoader, properties, environment);
    }

    @ConfigurationProperties(prefix="spring.cloud.maven")
    @Bean
    public MavenProperties mavenProperties() {
        return new MavenProperties();
    }

    @Bean
    public MavenResourceLoader mavenResourceLoader(MavenProperties mavenProperties) {
        return new MavenResourceLoader(mavenProperties);
    }

    @Bean
    public DelegatingResourceLoader delegatingResourceLoader(MavenResourceLoader mavenResourceLoader) {
        HashMap<String, MavenResourceLoader> map = new HashMap<String, MavenResourceLoader>();
        map.put("maven", mavenResourceLoader);
        return new DelegatingResourceLoader(map);
    }
}

