/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.tests.httpclient;

import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.util.Timeout;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.gateway.server.mvc.filter.FilterFunctions;
import org.springframework.cloud.gateway.server.mvc.filter.LoadBalancerFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.filter.RetryFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.handler.GatewayRouterFunctions;
import org.springframework.cloud.gateway.server.mvc.handler.HandlerFunctions;
import org.springframework.cloud.gateway.tests.httpclient.MyServiceConf;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.ServerResponse;

@SpringBootConfiguration
@EnableAutoConfiguration
@LoadBalancerClient(name="myservice", configuration={MyServiceConf.class})
public class HttpClientApplication {
    public static void main(String[] args) {
        SpringApplication.run(HttpClientApplication.class, (String[])args);
    }

    @Bean
    public HttpComponentsClientHttpRequestFactory httpComponentsClientHttpRequestFactory() {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(2);
        connectionManager.setDefaultMaxPerRoute(2);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(Timeout.of((Duration)Duration.ofMillis(3000L))).build()).build();
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        return factory;
    }

    @Bean
    public RouterFunction<ServerResponse> gatewayRouterFunctionsRetry() {
        return GatewayRouterFunctions.route((String)"test-retry").GET("/retry", HandlerFunctions.http()).filter(LoadBalancerFilterFunctions.lb((String)"myservice")).filter(FilterFunctions.prefixPath((String)"/do")).filter(RetryFilterFunctions.retry((int)3)).build();
    }

    @RestController
    protected static class RetryController {
        Log log = LogFactory.getLog(this.getClass());
        ConcurrentHashMap<String, AtomicInteger> map = new ConcurrentHashMap();

        protected RetryController() {
        }

        @GetMapping(value={"/do/retry"})
        public ResponseEntity<String> retry(@RequestParam(value="key") String key, @RequestParam(name="count", defaultValue="3") int count, @RequestParam(name="failStatus", required=false) Integer failStatus) {
            AtomicInteger num = this.map.computeIfAbsent(key, s -> new AtomicInteger());
            int i = num.incrementAndGet();
            this.log.warn((Object)("Retry count: " + i));
            String body = String.valueOf(i);
            if (i < count) {
                HttpStatus httpStatus = HttpStatus.INTERNAL_SERVER_ERROR;
                if (failStatus != null) {
                    httpStatus = HttpStatus.resolve((int)failStatus);
                }
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)httpStatus).header("X-Retry-Count", new String[]{body})).body((Object)"temporarily broken");
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.OK).header("X-Retry-Count", new String[]{body})).body((Object)body);
        }
    }
}

