/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.YamlProcessor;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginTrackedValue;
import org.springframework.boot.origin.TextResourceOrigin;
import org.springframework.core.io.Resource;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

class OriginTrackedYamlLoader
extends YamlProcessor {
    private final Resource resource;

    OriginTrackedYamlLoader(Resource resource) {
        this.resource = resource;
        this.setResources(new Resource[]{resource});
    }

    protected Yaml createYaml() {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setAllowDuplicateKeys(false);
        loaderOptions.setMaxAliasesForCollections(Integer.MAX_VALUE);
        loaderOptions.setAllowRecursiveKeys(true);
        loaderOptions.setCodePointLimit(Integer.MAX_VALUE);
        return this.createYaml(loaderOptions);
    }

    private Yaml createYaml(LoaderOptions loaderOptions) {
        OriginTrackingConstructor constructor = new OriginTrackingConstructor(loaderOptions);
        DumperOptions dumperOptions = new DumperOptions();
        Representer representer = new Representer(dumperOptions);
        NoTimestampResolver resolver = new NoTimestampResolver();
        return new Yaml((BaseConstructor)constructor, representer, dumperOptions, loaderOptions, (Resolver)resolver);
    }

    List<Map<String, Object>> load() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        this.process((properties, map) -> result.add(this.getFlattenedMap(map)));
        return result;
    }

    private class OriginTrackingConstructor
    extends SafeConstructor {
        OriginTrackingConstructor(LoaderOptions loadingConfig) {
            super(loadingConfig);
        }

        public @Nullable Object getData() throws NoSuchElementException {
            CharSequence charSequence;
            Object data = super.getData();
            if (data instanceof CharSequence && (charSequence = (CharSequence)data).isEmpty()) {
                return null;
            }
            return data;
        }

        protected Object constructObject(Node node) {
            SequenceNode sequenceNode;
            if (node instanceof SequenceNode && (sequenceNode = (SequenceNode)node).getValue().isEmpty()) {
                return this.constructTrackedObject(node, "");
            }
            if (node instanceof ScalarNode && !(node instanceof KeyScalarNode)) {
                return this.constructTrackedObject(node, super.constructObject(node));
            }
            if (node instanceof MappingNode) {
                MappingNode mappingNode = (MappingNode)node;
                this.replaceMappingNodeKeys(mappingNode);
            }
            return super.constructObject(node);
        }

        private void replaceMappingNodeKeys(MappingNode node) {
            List value = node.getValue();
            ArrayList<NodeTuple> newValue = new ArrayList<NodeTuple>(value.size());
            for (NodeTuple tuple : value) {
                newValue.add(KeyScalarNode.get(tuple));
            }
            node.setValue(newValue);
        }

        private Object constructTrackedObject(Node node, Object value) {
            Origin origin = this.getOrigin(node);
            return OriginTrackedValue.of(this.getValue(value), origin);
        }

        private Object getValue(@Nullable Object value) {
            return value != null ? value : "";
        }

        private Origin getOrigin(Node node) {
            Mark mark = node.getStartMark();
            TextResourceOrigin.Location location = new TextResourceOrigin.Location(mark.getLine(), mark.getColumn());
            return new TextResourceOrigin(OriginTrackedYamlLoader.this.resource, location);
        }
    }

    private static final class NoTimestampResolver
    extends Resolver {
        private NoTimestampResolver() {
        }

        public void addImplicitResolver(Tag tag, Pattern regexp, String first, int limit) {
            if (tag == Tag.TIMESTAMP) {
                return;
            }
            super.addImplicitResolver(tag, regexp, first, limit);
        }
    }

    private static class KeyScalarNode
    extends ScalarNode {
        KeyScalarNode(ScalarNode node) {
            super(node.getTag(), node.getValue(), node.getStartMark(), node.getEndMark(), node.getScalarStyle());
        }

        static NodeTuple get(NodeTuple nodeTuple) {
            Node keyNode = nodeTuple.getKeyNode();
            Node valueNode = nodeTuple.getValueNode();
            return new NodeTuple(KeyScalarNode.get(keyNode), valueNode);
        }

        private static Node get(Node node) {
            if (node instanceof ScalarNode) {
                ScalarNode scalarNode = (ScalarNode)node;
                return new KeyScalarNode(scalarNode);
            }
            return node;
        }
    }
}

