/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.structured;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.context.properties.bind.BindableRuntimeHintsRegistrar;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.StackTracePrinter;
import org.springframework.boot.logging.StandardStackTracePrinter;
import org.springframework.boot.logging.structured.StructuredLoggingJsonMembersCustomizer;
import org.springframework.boot.util.Instantiator;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

record StructuredLoggingJsonProperties(Set<String> include, Set<String> exclude, Map<String, String> rename, Map<String, String> add, StackTrace stackTrace, Context context, Set<Class<? extends StructuredLoggingJsonMembersCustomizer<?>>> customizer) {
    StructuredLoggingJsonProperties {
        customizer = customizer != null ? customizer : Collections.emptySet();
    }

    Collection<StructuredLoggingJsonMembersCustomizer<Object>> customizers(Instantiator<?> instantiator) {
        return this.customizer().stream().map(instantiator::instantiateType).toList();
    }

    static @Nullable StructuredLoggingJsonProperties get(Environment environment) {
        return Binder.get(environment).bind("logging.structured.json", StructuredLoggingJsonProperties.class).orElse(null);
    }

    record StackTrace(@Nullable String printer, Root root, Integer maxLength, Integer maxThrowableDepth, Boolean includeCommonFrames, Boolean includeHashes) {
        @Nullable StackTracePrinter createPrinter() {
            String name = this.sanitizePrinter();
            if ("loggingsystem".equals(name) || name.isEmpty() && !this.hasAnyOtherProperty()) {
                return null;
            }
            StandardStackTracePrinter standardPrinter = this.createStandardPrinter();
            if ("standard".equals(name) || name.isEmpty()) {
                return standardPrinter;
            }
            Assert.state((this.printer() != null ? 1 : 0) != 0, (String)"'printer' must not be null");
            return (StackTracePrinter)new Instantiator(StackTracePrinter.class, parameters -> parameters.add(StandardStackTracePrinter.class, standardPrinter)).instantiate(this.printer());
        }

        boolean hasCustomPrinter() {
            String name = this.sanitizePrinter();
            if (name.isEmpty()) {
                return false;
            }
            return !"loggingsystem".equals(name) && !"standard".equals(name);
        }

        private String sanitizePrinter() {
            return Objects.toString(this.printer(), "").toLowerCase(Locale.ROOT).replace("-", "");
        }

        private boolean hasAnyOtherProperty() {
            return Stream.of(new Serializable[]{this.root(), this.maxLength(), this.maxThrowableDepth(), this.includeCommonFrames(), this.includeHashes()}).anyMatch(x$0 -> Objects.nonNull(x$0));
        }

        private StandardStackTracePrinter createStandardPrinter() {
            StandardStackTracePrinter printer = this.root() == Root.FIRST ? StandardStackTracePrinter.rootFirst() : StandardStackTracePrinter.rootLast();
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            printer = map.from(this::maxLength).to(printer, StandardStackTracePrinter::withMaximumLength);
            printer = map.from(this::maxThrowableDepth).to(printer, StandardStackTracePrinter::withMaximumThrowableDepth);
            printer = map.from(this::includeCommonFrames).to(printer, this.apply(StandardStackTracePrinter::withCommonFrames));
            printer = map.from(this::includeHashes).to(printer, this.apply(StandardStackTracePrinter::withHashes));
            return printer;
        }

        private BiFunction<StandardStackTracePrinter, Boolean, StandardStackTracePrinter> apply(UnaryOperator<StandardStackTracePrinter> action) {
            return (printer, value) -> value == false ? printer : (StandardStackTracePrinter)action.apply((StandardStackTracePrinter)printer);
        }

        static enum Root {
            LAST,
            FIRST;

        }
    }

    record Context(boolean include, @Nullable String prefix) {
    }

    static class StructuredLoggingJsonPropertiesRuntimeHints
    implements RuntimeHintsRegistrar {
        StructuredLoggingJsonPropertiesRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            BindableRuntimeHintsRegistrar.forTypes(StructuredLoggingJsonProperties.class).registerHints(hints, classLoader);
        }
    }
}

