/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind.validation;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginProvider;
import org.springframework.validation.FieldError;

final class OriginTrackedFieldError
extends FieldError
implements OriginProvider {
    private final @Nullable Origin origin;

    private OriginTrackedFieldError(FieldError fieldError, @Nullable Origin origin) {
        super(fieldError.getObjectName(), fieldError.getField(), fieldError.getRejectedValue(), fieldError.isBindingFailure(), fieldError.getCodes(), fieldError.getArguments(), fieldError.getDefaultMessage());
        this.origin = origin;
    }

    @Override
    public @Nullable Origin getOrigin() {
        return this.origin;
    }

    public String toString() {
        if (this.origin == null) {
            return super.toString();
        }
        return super.toString() + "; origin " + String.valueOf(this.origin);
    }

    static @Nullable FieldError of(@Nullable FieldError fieldError, @Nullable Origin origin) {
        if (fieldError == null || origin == null) {
            return fieldError;
        }
        return new OriginTrackedFieldError(fieldError, origin);
    }
}

