/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.bind.BindConstructorProvider;
import org.springframework.boot.context.properties.bind.BindConverter;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.DataObjectBinder;
import org.springframework.boot.context.properties.bind.DataObjectPropertyBinder;
import org.springframework.boot.context.properties.bind.DataObjectPropertyName;
import org.springframework.boot.context.properties.bind.DefaultValue;
import org.springframework.boot.context.properties.bind.Name;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.core.CollectionFactory;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;

class ValueObjectBinder
implements DataObjectBinder {
    private static final Log logger = LogFactory.getLog(ValueObjectBinder.class);
    private final BindConstructorProvider constructorProvider;

    ValueObjectBinder(BindConstructorProvider constructorProvider) {
        this.constructorProvider = constructorProvider;
    }

    @Override
    public <T> @Nullable T bind(ConfigurationPropertyName name, Bindable<T> target, Binder.Context context, DataObjectPropertyBinder propertyBinder) {
        ValueObject<T> valueObject = ValueObject.get(target, context, this.constructorProvider, Discoverer.LENIENT);
        if (valueObject == null) {
            return null;
        }
        Class targetType = target.getType().resolve();
        Assert.state((targetType != null ? 1 : 0) != 0, (String)"'targetType' must not be null");
        context.pushConstructorBoundTypes(targetType);
        List<ConstructorParameter> parameters = valueObject.getConstructorParameters();
        ArrayList<Object> args = new ArrayList<Object>(parameters.size());
        boolean bound = false;
        for (ConstructorParameter parameter : parameters) {
            Object arg = parameter.bind(propertyBinder);
            bound = bound || arg != null;
            arg = arg != null ? arg : this.getDefaultValue(context, parameter);
            args.add(arg);
        }
        context.clearConfigurationProperty();
        context.popConstructorBoundTypes();
        return bound ? (T)valueObject.instantiate(args) : null;
    }

    @Override
    public <T> @Nullable T create(Bindable<T> target, Binder.Context context) {
        ValueObject<T> valueObject = ValueObject.get(target, context, this.constructorProvider, Discoverer.LENIENT);
        if (valueObject == null) {
            return null;
        }
        List<ConstructorParameter> parameters = valueObject.getConstructorParameters();
        ArrayList<Object> args = new ArrayList<Object>(parameters.size());
        for (ConstructorParameter parameter : parameters) {
            args.add(this.getDefaultValue(context, parameter));
        }
        return valueObject.instantiate(args);
    }

    @Override
    public <T> void onUnableToCreateInstance(Bindable<T> target, Binder.Context context, RuntimeException exception) {
        try {
            ValueObject.get(target, context, this.constructorProvider, Discoverer.STRICT);
        }
        catch (Exception ex) {
            exception.addSuppressed(ex);
        }
    }

    private <T> @Nullable T getDefaultValue(Binder.Context context, ConstructorParameter parameter) {
        Annotation[] annotations;
        ResolvableType type = parameter.getType();
        for (Annotation annotation : annotations = parameter.getAnnotations()) {
            if (!(annotation instanceof DefaultValue)) continue;
            DefaultValue defaultValueAnnotation = (DefaultValue)annotation;
            String[] defaultValue = defaultValueAnnotation.value();
            if (defaultValue.length == 0) {
                return this.getNewDefaultValueInstanceIfPossible(context, type);
            }
            return this.convertDefaultValue(context.getConverter(), defaultValue, type, annotations);
        }
        return null;
    }

    private <T> @Nullable T convertDefaultValue(BindConverter converter, String[] defaultValue, ResolvableType type, Annotation[] annotations) {
        try {
            return converter.convert((Object)defaultValue, type, annotations);
        }
        catch (ConversionException ex) {
            if (defaultValue.length == 1) {
                return converter.convert((Object)defaultValue[0], type, annotations);
            }
            throw ex;
        }
    }

    private <T> @Nullable T getNewDefaultValueInstanceIfPossible(Binder.Context context, ResolvableType type) {
        Object instance;
        Class resolved = type.resolve();
        Assert.state((resolved == null || this.isEmptyDefaultValueAllowed(resolved) ? 1 : 0) != 0, () -> "Parameter of type " + String.valueOf(type) + " must have a non-empty default value.");
        if (resolved != null) {
            if (Optional.class == resolved) {
                return (T)Optional.empty();
            }
            if (Collection.class.isAssignableFrom(resolved)) {
                return (T)CollectionFactory.createCollection((Class)resolved, (int)0);
            }
            if (EnumMap.class.isAssignableFrom(resolved)) {
                Class keyType = type.asMap().resolveGeneric(new int[]{0});
                return (T)CollectionFactory.createMap((Class)resolved, (Class)keyType, (int)0);
            }
            if (Map.class.isAssignableFrom(resolved)) {
                return (T)CollectionFactory.createMap((Class)resolved, (int)0);
            }
            if (resolved.isArray()) {
                return (T)Array.newInstance(resolved.getComponentType(), 0);
            }
        }
        if ((instance = this.create(Bindable.of(type), context)) != null) {
            return instance;
        }
        return (T)(resolved != null ? BeanUtils.instantiateClass((Class)resolved) : null);
    }

    private boolean isEmptyDefaultValueAllowed(Class<?> type) {
        return Optional.class == type || this.isAggregate(type) || !type.isPrimitive() && !type.isEnum() && !type.getName().startsWith("java.lang");
    }

    private boolean isAggregate(Class<?> type) {
        return type.isArray() || Map.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type);
    }

    static final class Discoverer
    implements ParameterNameDiscoverer {
        private static final ParameterNameDiscoverer DEFAULT_DELEGATE = new DefaultParameterNameDiscoverer();
        private static final ParameterNameDiscoverer LENIENT = new Discoverer(DEFAULT_DELEGATE, message -> {});
        private static final ParameterNameDiscoverer STRICT = new Discoverer(DEFAULT_DELEGATE, message -> {
            throw new IllegalStateException(message.toString());
        });
        private final ParameterNameDiscoverer delegate;
        private final Consumer<LogMessage> noParameterNamesHandler;

        private Discoverer(ParameterNameDiscoverer delegate, Consumer<LogMessage> noParameterNamesHandler) {
            this.delegate = delegate;
            this.noParameterNamesHandler = noParameterNamesHandler;
        }

        public String[] getParameterNames(Method method) {
            throw new UnsupportedOperationException();
        }

        public @Nullable String @Nullable [] getParameterNames(Constructor<?> constructor) {
            @Nullable String @Nullable [] names = this.delegate.getParameterNames(constructor);
            if (names != null) {
                return names;
            }
            LogMessage message = LogMessage.format((String)"Unable to use value object binding with constructor [%s] as parameter names cannot be discovered. Ensure that the compiler uses the '-parameters' flag", constructor);
            this.noParameterNamesHandler.accept(message);
            logger.debug((Object)message);
            return null;
        }
    }

    private static abstract class ValueObject<T> {
        private static final Object NONE = new Object();
        private final Constructor<T> constructor;

        protected ValueObject(Constructor<T> constructor) {
            this.constructor = constructor;
        }

        T instantiate(List<Object> args) {
            return (T)BeanUtils.instantiateClass(this.constructor, (Object[])args.toArray());
        }

        abstract List<ConstructorParameter> getConstructorParameters();

        static <T> @Nullable ValueObject<T> get(Bindable<T> bindable, Binder.Context context, BindConstructorProvider constructorProvider, ParameterNameDiscoverer parameterNameDiscoverer) {
            CacheKey cacheKey;
            Class resolvedType = bindable.getType().resolve();
            if (resolvedType == null || resolvedType.isEnum() || Modifier.isAbstract(resolvedType.getModifiers())) {
                return null;
            }
            Map<CacheKey, Object> cache = ValueObject.getCache(context);
            ValueObject<T> valueObject = cache.get(cacheKey = new CacheKey(bindable, constructorProvider, parameterNameDiscoverer));
            if (valueObject == null) {
                valueObject = ValueObject.get(bindable, context, constructorProvider, parameterNameDiscoverer, resolvedType);
                cache.put(cacheKey, valueObject != null ? valueObject : NONE);
            }
            return valueObject != NONE ? (ValueObject)valueObject : null;
        }

        private static <T> @Nullable ValueObject<T> get(Bindable<T> bindable, Binder.Context context, BindConstructorProvider constructorProvider, ParameterNameDiscoverer parameterNameDiscoverer, Class<T> resolvedType) {
            Constructor<?> bindConstructor = constructorProvider.getBindConstructor(bindable, context.isNestedConstructorBinding());
            if (bindConstructor == null) {
                return null;
            }
            if (KotlinDetector.isKotlinType(resolvedType)) {
                return KotlinValueObject.get(bindConstructor, bindable.getType(), parameterNameDiscoverer);
            }
            return DefaultValueObject.get(bindConstructor, bindable.getType(), parameterNameDiscoverer);
        }

        private static Map<CacheKey, Object> getCache(Binder.Context context) {
            ConcurrentHashMap cache = (ConcurrentHashMap)context.getCache().get(ValueObject.class);
            if (cache == null) {
                cache = new ConcurrentHashMap();
                context.getCache().put(ValueObject.class, cache);
            }
            return cache;
        }

        private record CacheKey(Bindable<?> bindable, BindConstructorProvider constructorProvider, ParameterNameDiscoverer parameterNameDiscoverer) {
        }
    }

    private static class ConstructorParameter {
        private final String name;
        private final ResolvableType type;
        private final Annotation[] annotations;

        ConstructorParameter(String name, ResolvableType type, Annotation[] annotations) {
            this.name = DataObjectPropertyName.toDashedForm(name);
            this.type = type;
            this.annotations = annotations;
        }

        @Nullable Object bind(DataObjectPropertyBinder propertyBinder) {
            return propertyBinder.bindProperty(this.name, Bindable.of(this.type).withAnnotations(this.annotations));
        }

        Annotation[] getAnnotations() {
            return this.annotations;
        }

        ResolvableType getType() {
            return this.type;
        }
    }

    private static final class DefaultValueObject<T>
    extends ValueObject<T> {
        private final List<ConstructorParameter> constructorParameters;

        private DefaultValueObject(Constructor<T> constructor, List<ConstructorParameter> constructorParameters) {
            super(constructor);
            this.constructorParameters = constructorParameters;
        }

        @Override
        List<ConstructorParameter> getConstructorParameters() {
            return this.constructorParameters;
        }

        static <T> @Nullable ValueObject<T> get(Constructor<?> bindConstructor, ResolvableType type, ParameterNameDiscoverer parameterNameDiscoverer) {
            @Nullable String @Nullable [] names = parameterNameDiscoverer.getParameterNames(bindConstructor);
            if (names == null) {
                return null;
            }
            List<ConstructorParameter> constructorParameters = DefaultValueObject.parseConstructorParameters(bindConstructor, type, names);
            return new DefaultValueObject(bindConstructor, constructorParameters);
        }

        private static List<ConstructorParameter> parseConstructorParameters(Constructor<?> constructor, ResolvableType type, @Nullable String[] names) {
            Parameter[] parameters = constructor.getParameters();
            ArrayList<ConstructorParameter> result = new ArrayList<ConstructorParameter>(parameters.length);
            for (int i = 0; i < parameters.length; ++i) {
                String name = MergedAnnotations.from((AnnotatedElement)parameters[i]).get(Name.class).getValue("value", String.class).orElse(names[i]);
                ResolvableType parameterType = ResolvableType.forMethodParameter((MethodParameter)new MethodParameter(constructor, i), (ResolvableType)type);
                Annotation[] annotations = parameters[i].getDeclaredAnnotations();
                Assert.state((name != null ? 1 : 0) != 0, (String)"'name' must not be null");
                result.add(new ConstructorParameter(name, parameterType, annotations));
            }
            return Collections.unmodifiableList(result);
        }
    }

    private static final class KotlinValueObject<T>
    extends ValueObject<T> {
        private static final Annotation[] ANNOTATION_ARRAY = new Annotation[0];
        private final List<ConstructorParameter> constructorParameters;

        private KotlinValueObject(Constructor<T> primaryConstructor, KFunction<T> kotlinConstructor, ResolvableType type) {
            super(primaryConstructor);
            this.constructorParameters = this.parseConstructorParameters(kotlinConstructor, type);
        }

        private List<ConstructorParameter> parseConstructorParameters(KFunction<T> kotlinConstructor, ResolvableType type) {
            List parameters = kotlinConstructor.getParameters();
            ArrayList<ConstructorParameter> result = new ArrayList<ConstructorParameter>(parameters.size());
            for (KParameter parameter : parameters) {
                String name = this.getParameterName(parameter);
                ResolvableType parameterType = ResolvableType.forType((Type)ReflectJvmMapping.getJavaType((KType)parameter.getType()), (ResolvableType)type);
                Annotation[] annotations = parameter.getAnnotations().toArray(ANNOTATION_ARRAY);
                result.add(new ConstructorParameter(name, parameterType, annotations));
            }
            return Collections.unmodifiableList(result);
        }

        private String getParameterName(KParameter parameter) {
            return MergedAnnotations.from((Object)parameter, (Annotation[])parameter.getAnnotations().toArray(ANNOTATION_ARRAY)).get(Name.class).getValue("value", String.class).orElseGet(() -> ((KParameter)parameter).getName());
        }

        @Override
        List<ConstructorParameter> getConstructorParameters() {
            return this.constructorParameters;
        }

        static <T> @Nullable ValueObject<T> get(Constructor<T> bindConstructor, ResolvableType type, ParameterNameDiscoverer parameterNameDiscoverer) {
            KFunction kotlinConstructor = ReflectJvmMapping.getKotlinFunction(bindConstructor);
            if (kotlinConstructor != null) {
                return new KotlinValueObject<T>(bindConstructor, kotlinConstructor, type);
            }
            return DefaultValueObject.get(bindConstructor, type, parameterNameDiscoverer);
        }
    }
}

