/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.context.properties.BindMethodAttribute;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.BindConstructorProvider;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.annotation.Validated;

public final class ConfigurationPropertiesBean {
    private static final org.springframework.boot.context.properties.bind.BindMethod JAVA_BEAN_BIND_METHOD = org.springframework.boot.context.properties.bind.BindMethod.JAVA_BEAN;
    private static final org.springframework.boot.context.properties.bind.BindMethod VALUE_OBJECT_BIND_METHOD = org.springframework.boot.context.properties.bind.BindMethod.VALUE_OBJECT;
    private final String name;
    private final Object instance;
    private final Bindable<?> bindTarget;

    private ConfigurationPropertiesBean(String name, Object instance, Bindable<?> bindTarget) {
        this.name = name;
        this.instance = instance;
        this.bindTarget = bindTarget;
    }

    public String getName() {
        return this.name;
    }

    public Object getInstance() {
        return this.instance;
    }

    Class<?> getType() {
        return this.bindTarget.getType().resolve();
    }

    @Deprecated(since="3.0.8", forRemoval=true)
    public BindMethod getBindMethod() {
        return BindMethod.from(this.bindTarget.getBindMethod());
    }

    public ConfigurationProperties getAnnotation() {
        return this.bindTarget.getAnnotation(ConfigurationProperties.class);
    }

    public Bindable<?> asBindTarget() {
        return this.bindTarget;
    }

    public static Map<String, ConfigurationPropertiesBean> getAll(ApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"ApplicationContext must not be null");
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)applicationContext;
            return ConfigurationPropertiesBean.getAll(configurableContext);
        }
        LinkedHashMap<String, ConfigurationPropertiesBean> propertiesBeans = new LinkedHashMap<String, ConfigurationPropertiesBean>();
        applicationContext.getBeansWithAnnotation(ConfigurationProperties.class).forEach((name, instance) -> {
            ConfigurationPropertiesBean propertiesBean = ConfigurationPropertiesBean.get(applicationContext, instance, name);
            if (propertiesBean != null) {
                propertiesBeans.put((String)name, propertiesBean);
            }
        });
        return propertiesBeans;
    }

    private static Map<String, ConfigurationPropertiesBean> getAll(ConfigurableApplicationContext applicationContext) {
        LinkedHashMap<String, ConfigurationPropertiesBean> propertiesBeans = new LinkedHashMap<String, ConfigurationPropertiesBean>();
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        Iterator beanNames = beanFactory.getBeanNamesIterator();
        while (beanNames.hasNext()) {
            String beanName = (String)beanNames.next();
            if (!ConfigurationPropertiesBean.isConfigurationPropertiesBean(beanFactory, beanName)) continue;
            try {
                Object bean = beanFactory.getBean(beanName);
                ConfigurationPropertiesBean propertiesBean = ConfigurationPropertiesBean.get((ApplicationContext)applicationContext, bean, beanName);
                if (propertiesBean == null) continue;
                propertiesBeans.put(beanName, propertiesBean);
            }
            catch (Exception exception) {}
        }
        return propertiesBeans;
    }

    private static boolean isConfigurationPropertiesBean(ConfigurableListableBeanFactory beanFactory, String beanName) {
        try {
            if (beanFactory.getBeanDefinition(beanName).isAbstract()) {
                return false;
            }
            if (beanFactory.findAnnotationOnBean(beanName, ConfigurationProperties.class) != null) {
                return true;
            }
            Method factoryMethod = ConfigurationPropertiesBean.findFactoryMethod(beanFactory, beanName);
            return ConfigurationPropertiesBean.findMergedAnnotation(factoryMethod, ConfigurationProperties.class).isPresent();
        }
        catch (NoSuchBeanDefinitionException ex) {
            return false;
        }
    }

    public static ConfigurationPropertiesBean get(ApplicationContext applicationContext, Object bean, String beanName) {
        Method factoryMethod = ConfigurationPropertiesBean.findFactoryMethod(applicationContext, beanName);
        Bindable<Object> bindTarget = ConfigurationPropertiesBean.createBindTarget(bean, bean.getClass(), factoryMethod);
        if (bindTarget == null) {
            return null;
        }
        if ((bindTarget = bindTarget.withBindMethod(BindMethodAttribute.get(applicationContext, beanName))).getBindMethod() == null && factoryMethod != null) {
            bindTarget = bindTarget.withBindMethod(JAVA_BEAN_BIND_METHOD);
        }
        if (bindTarget.getBindMethod() == null) {
            bindTarget = bindTarget.withBindMethod(ConfigurationPropertiesBean.deduceBindMethod(bindTarget));
        }
        if (bindTarget.getBindMethod() != VALUE_OBJECT_BIND_METHOD) {
            bindTarget = bindTarget.withExistingValue(bean);
        }
        return ConfigurationPropertiesBean.create(beanName, bean, bindTarget);
    }

    private static Method findFactoryMethod(ApplicationContext applicationContext, String beanName) {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)applicationContext;
            return ConfigurationPropertiesBean.findFactoryMethod(configurableContext, beanName);
        }
        return null;
    }

    private static Method findFactoryMethod(ConfigurableApplicationContext applicationContext, String beanName) {
        return ConfigurationPropertiesBean.findFactoryMethod(applicationContext.getBeanFactory(), beanName);
    }

    private static Method findFactoryMethod(ConfigurableListableBeanFactory beanFactory, String beanName) {
        if (beanFactory.containsBeanDefinition(beanName)) {
            RootBeanDefinition rootBeanDefinition;
            Method resolvedFactoryMethod;
            BeanDefinition beanDefinition = beanFactory.getMergedBeanDefinition(beanName);
            if (beanDefinition instanceof RootBeanDefinition && (resolvedFactoryMethod = (rootBeanDefinition = (RootBeanDefinition)beanDefinition).getResolvedFactoryMethod()) != null) {
                return resolvedFactoryMethod;
            }
            return ConfigurationPropertiesBean.findFactoryMethodUsingReflection(beanFactory, beanDefinition);
        }
        return null;
    }

    private static Method findFactoryMethodUsingReflection(ConfigurableListableBeanFactory beanFactory, BeanDefinition beanDefinition) {
        String factoryMethodName = beanDefinition.getFactoryMethodName();
        String factoryBeanName = beanDefinition.getFactoryBeanName();
        if (factoryMethodName == null || factoryBeanName == null) {
            return null;
        }
        Class factoryType = beanFactory.getType(factoryBeanName);
        if (factoryType.getName().contains("$$")) {
            factoryType = factoryType.getSuperclass();
        }
        AtomicReference factoryMethod = new AtomicReference();
        ReflectionUtils.doWithMethods(factoryType, method -> {
            if (method.getName().equals(factoryMethodName)) {
                factoryMethod.set(method);
            }
        });
        return (Method)factoryMethod.get();
    }

    static ConfigurationPropertiesBean forValueObject(Class<?> beanType, String beanName) {
        Bindable<Object> bindTarget = ConfigurationPropertiesBean.createBindTarget(null, beanType, null);
        Assert.state((bindTarget != null && ConfigurationPropertiesBean.deduceBindMethod(bindTarget) == VALUE_OBJECT_BIND_METHOD ? 1 : 0) != 0, () -> "Bean '" + beanName + "' is not a @ConfigurationProperties value object");
        return ConfigurationPropertiesBean.create(beanName, null, bindTarget.withBindMethod(VALUE_OBJECT_BIND_METHOD));
    }

    private static Bindable<Object> createBindTarget(Object bean, Class<?> beanType, Method factoryMethod) {
        ResolvableType type = factoryMethod != null ? ResolvableType.forMethodReturnType((Method)factoryMethod) : ResolvableType.forClass(beanType);
        Annotation[] annotations = ConfigurationPropertiesBean.findAnnotations(bean, beanType, factoryMethod);
        return annotations != null ? Bindable.of(type).withAnnotations(annotations) : null;
    }

    private static Annotation[] findAnnotations(Object instance, Class<?> type, Method factory) {
        Annotation[] annotationArray;
        ConfigurationProperties annotation = ConfigurationPropertiesBean.findAnnotation(instance, type, factory, ConfigurationProperties.class);
        if (annotation == null) {
            return null;
        }
        Validated validated = ConfigurationPropertiesBean.findAnnotation(instance, type, factory, Validated.class);
        if (validated != null) {
            Annotation[] annotationArray2 = new Annotation[2];
            annotationArray2[0] = annotation;
            annotationArray = annotationArray2;
            annotationArray2[1] = validated;
        } else {
            Annotation[] annotationArray3 = new Annotation[1];
            annotationArray = annotationArray3;
            annotationArray3[0] = annotation;
        }
        return annotationArray;
    }

    private static <A extends Annotation> A findAnnotation(Object instance, Class<?> type, Method factory, Class<A> annotationType) {
        MergedAnnotation annotation = MergedAnnotation.missing();
        if (factory != null) {
            annotation = ConfigurationPropertiesBean.findMergedAnnotation(factory, annotationType);
        }
        if (!annotation.isPresent()) {
            annotation = ConfigurationPropertiesBean.findMergedAnnotation(type, annotationType);
        }
        if (!annotation.isPresent() && AopUtils.isAopProxy((Object)instance)) {
            annotation = MergedAnnotations.from((AnnotatedElement)AopUtils.getTargetClass((Object)instance), (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(annotationType);
        }
        return (A)(annotation.isPresent() ? annotation.synthesize() : null);
    }

    private static <A extends Annotation> MergedAnnotation<A> findMergedAnnotation(AnnotatedElement element, Class<A> annotationType) {
        return element != null ? MergedAnnotations.from((AnnotatedElement)element, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(annotationType) : MergedAnnotation.missing();
    }

    private static ConfigurationPropertiesBean create(String name, Object instance, Bindable<Object> bindTarget) {
        return bindTarget != null ? new ConfigurationPropertiesBean(name, instance, bindTarget) : null;
    }

    static org.springframework.boot.context.properties.bind.BindMethod deduceBindMethod(Class<?> type) {
        return ConfigurationPropertiesBean.deduceBindMethod(BindConstructorProvider.DEFAULT.getBindConstructor(type, false));
    }

    static org.springframework.boot.context.properties.bind.BindMethod deduceBindMethod(Bindable<Object> bindable) {
        return ConfigurationPropertiesBean.deduceBindMethod(BindConstructorProvider.DEFAULT.getBindConstructor(bindable, false));
    }

    private static org.springframework.boot.context.properties.bind.BindMethod deduceBindMethod(Constructor<?> bindConstructor) {
        return bindConstructor != null ? VALUE_OBJECT_BIND_METHOD : JAVA_BEAN_BIND_METHOD;
    }

    @Deprecated(since="3.0.8", forRemoval=true)
    public static enum BindMethod {
        JAVA_BEAN,
        VALUE_OBJECT;


        static BindMethod from(org.springframework.boot.context.properties.bind.BindMethod bindMethod) {
            if (bindMethod == null) {
                return null;
            }
            return switch (bindMethod) {
                default -> throw new IncompatibleClassChangeError();
                case org.springframework.boot.context.properties.bind.BindMethod.VALUE_OBJECT -> VALUE_OBJECT;
                case org.springframework.boot.context.properties.bind.BindMethod.JAVA_BEAN -> JAVA_BEAN;
            };
        }
    }
}

