/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.zipkin.testcontainers;

import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.springframework.boot.zipkin.autoconfigure.ZipkinConnectionDetails;
import org.testcontainers.containers.Container;

class ZipkinContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<Container<?>, ZipkinConnectionDetails> {
    private static final int ZIPKIN_PORT = 9411;

    ZipkinContainerConnectionDetailsFactory() {
        super("openzipkin/zipkin", new String[]{"org.springframework.boot.zipkin.autoconfigure.ZipkinAutoConfiguration"});
    }

    protected ZipkinConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
        return new ZipkinContainerConnectionDetails(source);
    }

    private static class ZipkinContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<Container<?>>
    implements ZipkinConnectionDetails {
        ZipkinContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
            super(source);
        }

        @Override
        public String getSpanEndpoint() {
            return "http://" + this.getContainer().getHost() + ":" + this.getContainer().getMappedPort(9411) + "/api/v2/spans";
        }
    }
}

