/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.websocket.autoconfigure.servlet;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.LazyInitializationExcludeFilter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.JacksonJsonMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.simp.config.AbstractMessageBrokerConfiguration;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.socket.config.annotation.DelegatingWebSocketMessageBrokerConfiguration;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import tools.jackson.databind.json.JsonMapper;

@AutoConfiguration(afterName={"org.springframework.boot.jackson.autoconfigure.JacksonAutoConfiguration"})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={WebSocketMessageBrokerConfigurer.class})
public final class WebSocketMessagingAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={DelegatingWebSocketMessageBrokerConfiguration.class, JsonMapper.class})
    @ConditionalOnClass(value={JsonMapper.class, AbstractMessageBrokerConfiguration.class})
    @Order(value=0)
    static class WebSocketMessageConverterConfiguration
    implements WebSocketMessageBrokerConfigurer {
        private final JsonMapper jsonMapper;
        private final @Nullable AsyncTaskExecutor executor;

        WebSocketMessageConverterConfiguration(JsonMapper jsonMapper, Map<String, AsyncTaskExecutor> taskExecutors) {
            this.jsonMapper = jsonMapper;
            this.executor = WebSocketMessageConverterConfiguration.determineAsyncTaskExecutor(taskExecutors);
        }

        private static @Nullable AsyncTaskExecutor determineAsyncTaskExecutor(Map<String, AsyncTaskExecutor> taskExecutors) {
            if (taskExecutors.size() == 1) {
                return taskExecutors.values().iterator().next();
            }
            return taskExecutors.get("applicationTaskExecutor");
        }

        public boolean configureMessageConverters(List<MessageConverter> messageConverters) {
            JacksonJsonMessageConverter converter = new JacksonJsonMessageConverter(this.jsonMapper);
            DefaultContentTypeResolver resolver = new DefaultContentTypeResolver();
            resolver.setDefaultMimeType(MimeTypeUtils.APPLICATION_JSON);
            converter.setContentTypeResolver((ContentTypeResolver)resolver);
            messageConverters.add((MessageConverter)new StringMessageConverter());
            messageConverters.add((MessageConverter)new ByteArrayMessageConverter());
            messageConverters.add((MessageConverter)converter);
            return false;
        }

        public void configureClientInboundChannel(ChannelRegistration registration) {
            if (this.executor != null) {
                registration.executor((Executor)this.executor);
            }
        }

        public void configureClientOutboundChannel(ChannelRegistration registration) {
            if (this.executor != null) {
                registration.executor((Executor)this.executor);
            }
        }

        @Bean
        static LazyInitializationExcludeFilter eagerStompWebSocketHandlerMapping() {
            return (name, definition, type) -> name.equals("stompWebSocketHandlerMapping");
        }
    }
}

