/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webmvc.autoconfigure;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingFilterBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProviders;
import org.springframework.boot.autoconfigure.web.ConditionalOnEnabledResourceChain;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.WebResourcesRuntimeHints;
import org.springframework.boot.autoconfigure.web.format.DateTimeFormatters;
import org.springframework.boot.autoconfigure.web.format.WebConversionService;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.boot.http.converter.autoconfigure.ServerHttpMessageConvertersCustomizer;
import org.springframework.boot.servlet.filter.OrderedFormContentFilter;
import org.springframework.boot.servlet.filter.OrderedHiddenHttpMethodFilter;
import org.springframework.boot.servlet.filter.OrderedRequestContextFilter;
import org.springframework.boot.validation.autoconfigure.ValidatorAdapter;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.boot.webmvc.autoconfigure.DispatcherServletAutoConfiguration;
import org.springframework.boot.webmvc.autoconfigure.DispatcherServletPath;
import org.springframework.boot.webmvc.autoconfigure.ProblemDetailsExceptionHandler;
import org.springframework.boot.webmvc.autoconfigure.WebMvcProperties;
import org.springframework.boot.webmvc.autoconfigure.WebMvcRegistrations;
import org.springframework.boot.webmvc.autoconfigure.WelcomePageHandlerMapping;
import org.springframework.boot.webmvc.autoconfigure.WelcomePageNotAcceptableHandlerMapping;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverters;
import org.springframework.lang.Contract;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PathMatcher;
import org.springframework.validation.DefaultMessageCodesResolver;
import org.springframework.validation.MessageCodeFormatter;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.Validator;
import org.springframework.web.accept.ApiVersionDeprecationHandler;
import org.springframework.web.accept.ApiVersionParser;
import org.springframework.web.accept.ApiVersionResolver;
import org.springframework.web.accept.ApiVersionStrategy;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.filter.FormContentFilter;
import org.springframework.web.filter.HiddenHttpMethodFilter;
import org.springframework.web.filter.RequestContextFilter;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.RequestToViewNameTranslator;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.ApiVersionConfigurer;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.DelegatingWebMvcConfiguration;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceChainRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;
import org.springframework.web.servlet.i18n.FixedLocaleResolver;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;
import org.springframework.web.servlet.resource.EncodedResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceUrlProvider;
import org.springframework.web.servlet.resource.VersionResourceResolver;
import org.springframework.web.servlet.view.BeanNameViewResolver;
import org.springframework.web.servlet.view.ContentNegotiatingViewResolver;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.util.UrlPathHelper;

@AutoConfiguration(after={DispatcherServletAutoConfiguration.class, TaskExecutionAutoConfiguration.class}, afterName={"org.springframework.boot.validation.autoconfigure.ValidationAutoConfiguration"})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurer.class})
@ConditionalOnMissingBean(value={WebMvcConfigurationSupport.class})
@AutoConfigureOrder(value=-2147483638)
@ImportRuntimeHints(value={WebResourcesRuntimeHints.class})
public final class WebMvcAutoConfiguration {
    public static final String DEFAULT_PREFIX = "";
    public static final String DEFAULT_SUFFIX = "";
    private static final String SERVLET_LOCATION = "/";

    @Bean
    @ConditionalOnMissingBean(value={HiddenHttpMethodFilter.class})
    @ConditionalOnBooleanProperty(value={"spring.mvc.hiddenmethod.filter.enabled"})
    OrderedHiddenHttpMethodFilter hiddenHttpMethodFilter() {
        return new OrderedHiddenHttpMethodFilter();
    }

    @Bean
    @ConditionalOnMissingBean(value={FormContentFilter.class})
    @ConditionalOnBooleanProperty(name={"spring.mvc.formcontent.filter.enabled"}, matchIfMissing=true)
    OrderedFormContentFilter formContentFilter() {
        return new OrderedFormContentFilter();
    }

    static class MvcValidatorRuntimeHints
    implements RuntimeHintsRegistrar {
        MvcValidatorRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            hints.reflection().registerType(TypeReference.of((String)"org.springframework.boot.validation.autoconfigure.ValidatorAdapter"), new MemberCategory[0]);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBooleanProperty(value={"spring.mvc.problemdetails.enabled"})
    static class ProblemDetailsErrorHandlingConfiguration {
        ProblemDetailsErrorHandlingConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={ResponseEntityExceptionHandler.class})
        @Order(value=0)
        ProblemDetailsExceptionHandler problemDetailsExceptionHandler() {
            return new ProblemDetailsExceptionHandler();
        }
    }

    static class ResourceChainResourceHandlerRegistrationCustomizer
    implements ResourceHandlerRegistrationCustomizer {
        private final WebProperties.Resources resourceProperties;

        ResourceChainResourceHandlerRegistrationCustomizer(WebProperties.Resources resourceProperties) {
            this.resourceProperties = resourceProperties;
        }

        @Override
        public void customize(ResourceHandlerRegistration registration) {
            WebProperties.Resources.Chain properties = this.resourceProperties.getChain();
            this.configureResourceChain(properties, registration.resourceChain(properties.isCache()));
        }

        private void configureResourceChain(WebProperties.Resources.Chain properties, ResourceChainRegistration chain) {
            WebProperties.Resources.Chain.Strategy strategy = properties.getStrategy();
            if (properties.isCompressed()) {
                chain.addResolver((ResourceResolver)new EncodedResourceResolver());
            }
            if (strategy.getFixed().isEnabled() || strategy.getContent().isEnabled()) {
                chain.addResolver(this.getVersionResourceResolver(strategy));
            }
        }

        private ResourceResolver getVersionResourceResolver(WebProperties.Resources.Chain.Strategy properties) {
            VersionResourceResolver resolver = new VersionResourceResolver();
            if (properties.getFixed().isEnabled()) {
                String version = properties.getFixed().getVersion();
                String[] paths = properties.getFixed().getPaths();
                Assert.state((version != null ? 1 : 0) != 0, (String)"'version' must not be null");
                resolver.addFixedVersionStrategy(version, paths);
            }
            if (properties.getContent().isEnabled()) {
                String[] paths = properties.getContent().getPaths();
                resolver.addContentVersionStrategy(paths);
            }
            return resolver;
        }
    }

    @FunctionalInterface
    static interface ResourceHandlerRegistrationCustomizer {
        public void customize(ResourceHandlerRegistration var1);
    }

    @FunctionalInterface
    static interface WelcomePageHandlerMappingFactory<T extends AbstractUrlHandlerMapping> {
        public T create(TemplateAvailabilityProviders var1, ApplicationContext var2, @Nullable Resource var3, String var4);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnEnabledResourceChain
    static class ResourceChainCustomizerConfiguration {
        ResourceChainCustomizerConfiguration() {
        }

        @Bean
        ResourceChainResourceHandlerRegistrationCustomizer resourceHandlerRegistrationCustomizer(WebProperties webProperties) {
            return new ResourceChainResourceHandlerRegistrationCustomizer(webProperties.getResources());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={WebProperties.class})
    @ImportRuntimeHints(value={MvcValidatorRuntimeHints.class})
    static class EnableWebMvcConfiguration
    extends DelegatingWebMvcConfiguration
    implements ResourceLoaderAware {
        private final WebProperties.Resources resourceProperties;
        private final WebMvcProperties mvcProperties;
        private final WebProperties webProperties;
        private final ListableBeanFactory beanFactory;
        private final @Nullable WebMvcRegistrations mvcRegistrations;
        private ResourceLoader resourceLoader;

        EnableWebMvcConfiguration(WebMvcProperties mvcProperties, WebProperties webProperties, ObjectProvider<WebMvcRegistrations> mvcRegistrationsProvider, ObjectProvider<ResourceHandlerRegistrationCustomizer> resourceHandlerRegistrationCustomizerProvider, ListableBeanFactory beanFactory) {
            this.resourceProperties = webProperties.getResources();
            this.mvcProperties = mvcProperties;
            this.webProperties = webProperties;
            this.mvcRegistrations = (WebMvcRegistrations)mvcRegistrationsProvider.getIfUnique();
            this.beanFactory = beanFactory;
        }

        protected RequestMappingHandlerAdapter createRequestMappingHandlerAdapter() {
            RequestMappingHandlerAdapter adapter;
            if (this.mvcRegistrations != null && (adapter = this.mvcRegistrations.getRequestMappingHandlerAdapter()) != null) {
                return adapter;
            }
            return super.createRequestMappingHandlerAdapter();
        }

        @Bean
        WelcomePageHandlerMapping welcomePageHandlerMapping(ApplicationContext applicationContext, FormattingConversionService mvcConversionService, ResourceUrlProvider mvcResourceUrlProvider) {
            return this.createWelcomePageHandlerMapping(applicationContext, mvcConversionService, mvcResourceUrlProvider, WelcomePageHandlerMapping::new);
        }

        @Bean
        WelcomePageNotAcceptableHandlerMapping welcomePageNotAcceptableHandlerMapping(ApplicationContext applicationContext, FormattingConversionService mvcConversionService, ResourceUrlProvider mvcResourceUrlProvider) {
            return this.createWelcomePageHandlerMapping(applicationContext, mvcConversionService, mvcResourceUrlProvider, WelcomePageNotAcceptableHandlerMapping::new);
        }

        private <T extends AbstractUrlHandlerMapping> T createWelcomePageHandlerMapping(ApplicationContext applicationContext, FormattingConversionService mvcConversionService, ResourceUrlProvider mvcResourceUrlProvider, WelcomePageHandlerMappingFactory<T> factory) {
            TemplateAvailabilityProviders templateAvailabilityProviders = new TemplateAvailabilityProviders(applicationContext);
            String staticPathPattern = this.mvcProperties.getStaticPathPattern();
            T handlerMapping = factory.create(templateAvailabilityProviders, applicationContext, this.getIndexHtmlResource(), staticPathPattern);
            handlerMapping.setInterceptors(this.getInterceptors(mvcConversionService, mvcResourceUrlProvider));
            handlerMapping.setCorsConfigurations(this.getCorsConfigurations());
            return handlerMapping;
        }

        @Bean
        @ConditionalOnMissingBean(name={"localeResolver"})
        public LocaleResolver localeResolver() {
            Locale locale = this.webProperties.getLocale();
            if (this.webProperties.getLocaleResolver() == WebProperties.LocaleResolver.FIXED) {
                Assert.state((locale != null ? 1 : 0) != 0, (String)"'locale' must not be null");
                return new FixedLocaleResolver(locale);
            }
            AcceptHeaderLocaleResolver localeResolver = new AcceptHeaderLocaleResolver();
            localeResolver.setDefaultLocale(locale);
            return localeResolver;
        }

        @Bean
        @ConditionalOnMissingBean(name={"flashMapManager"})
        public FlashMapManager flashMapManager() {
            return super.flashMapManager();
        }

        @Bean
        @ConditionalOnMissingBean(name={"viewNameTranslator"})
        public RequestToViewNameTranslator viewNameTranslator() {
            return super.viewNameTranslator();
        }

        private @Nullable Resource getIndexHtmlResource() {
            for (String location : this.resourceProperties.getStaticLocations()) {
                Resource indexHtml = this.getIndexHtmlResource(location);
                if (indexHtml == null) continue;
                return indexHtml;
            }
            ServletContext servletContext = this.getServletContext();
            if (servletContext != null) {
                return this.getIndexHtmlResource((Resource)new ServletContextResource(servletContext, WebMvcAutoConfiguration.SERVLET_LOCATION));
            }
            return null;
        }

        private @Nullable Resource getIndexHtmlResource(String location) {
            return this.getIndexHtmlResource(this.resourceLoader.getResource(location));
        }

        private @Nullable Resource getIndexHtmlResource(Resource location) {
            try {
                Resource resource = location.createRelative("index.html");
                if (resource.exists() && resource.getURL() != null) {
                    return resource;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Bean
        public FormattingConversionService mvcConversionService() {
            WebMvcProperties.Format format = this.mvcProperties.getFormat();
            WebConversionService conversionService = new WebConversionService(new DateTimeFormatters().dateFormat(format.getDate()).timeFormat(format.getTime()).dateTimeFormat(format.getDateTime()));
            this.addFormatters((FormatterRegistry)conversionService);
            return conversionService;
        }

        @Bean
        public Validator mvcValidator() {
            if (!ClassUtils.isPresent((String)"jakarta.validation.Validator", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()) || !ClassUtils.isPresent((String)"org.springframework.boot.validation.autoconfigure.ValidatorAdapter", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader())) {
                return super.mvcValidator();
            }
            ApplicationContext applicationContext = this.getApplicationContext();
            Assert.state((applicationContext != null ? 1 : 0) != 0, (String)"'applicationContext' must not be null");
            return ValidatorAdapter.get((ApplicationContext)applicationContext, (Validator)this.getValidator());
        }

        protected RequestMappingHandlerMapping createRequestMappingHandlerMapping() {
            RequestMappingHandlerMapping mapping;
            if (this.mvcRegistrations != null && (mapping = this.mvcRegistrations.getRequestMappingHandlerMapping()) != null) {
                return mapping;
            }
            return super.createRequestMappingHandlerMapping();
        }

        protected ConfigurableWebBindingInitializer getConfigurableWebBindingInitializer(FormattingConversionService mvcConversionService, Validator mvcValidator) {
            try {
                return (ConfigurableWebBindingInitializer)this.beanFactory.getBean(ConfigurableWebBindingInitializer.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                return super.getConfigurableWebBindingInitializer(mvcConversionService, mvcValidator);
            }
        }

        protected ExceptionHandlerExceptionResolver createExceptionHandlerExceptionResolver() {
            ExceptionHandlerExceptionResolver resolver;
            if (this.mvcRegistrations != null && (resolver = this.mvcRegistrations.getExceptionHandlerExceptionResolver()) != null) {
                return resolver;
            }
            return super.createExceptionHandlerExceptionResolver();
        }

        protected void extendHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
            super.extendHandlerExceptionResolvers(exceptionResolvers);
            if (this.mvcProperties.isLogResolvedException()) {
                for (HandlerExceptionResolver resolver : exceptionResolvers) {
                    if (!(resolver instanceof AbstractHandlerExceptionResolver)) continue;
                    AbstractHandlerExceptionResolver abstractResolver = (AbstractHandlerExceptionResolver)resolver;
                    abstractResolver.setWarnLogCategory(resolver.getClass().getName());
                }
            }
        }

        public void setResourceLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }

        @ConditionalOnMissingBean(name={"mvcApiVersionStrategy"})
        public @Nullable ApiVersionStrategy mvcApiVersionStrategy() {
            return super.mvcApiVersionStrategy();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={EnableWebMvcConfiguration.class})
    @EnableConfigurationProperties(value={WebMvcProperties.class, WebProperties.class})
    @Order(value=0)
    static class WebMvcAutoConfigurationAdapter
    implements WebMvcConfigurer,
    ServletContextAware {
        private static final Log logger = LogFactory.getLog(WebMvcConfigurer.class);
        private final WebProperties.Resources resourceProperties;
        private final WebMvcProperties mvcProperties;
        private final ListableBeanFactory beanFactory;
        private final ObjectProvider<DispatcherServletPath> dispatcherServletPath;
        private final ObjectProvider<ServletRegistrationBean<?>> servletRegistrations;
        private final ObjectProvider<ServerHttpMessageConvertersCustomizer> httpMessageConvertersCustomizerProvider;
        private final @Nullable ResourceHandlerRegistrationCustomizer resourceHandlerRegistrationCustomizer;
        private @Nullable ServletContext servletContext;
        private final ObjectProvider<ApiVersionResolver> apiVersionResolvers;
        private final ObjectProvider<ApiVersionParser<?>> apiVersionParser;
        private final ObjectProvider<ApiVersionDeprecationHandler> apiVersionDeprecationHandler;

        WebMvcAutoConfigurationAdapter(WebProperties webProperties, WebMvcProperties mvcProperties, ListableBeanFactory beanFactory, ObjectProvider<ServerHttpMessageConvertersCustomizer> httpMessageConvertersCustomizerProvider, ObjectProvider<ResourceHandlerRegistrationCustomizer> resourceHandlerRegistrationCustomizerProvider, ObjectProvider<DispatcherServletPath> dispatcherServletPath, ObjectProvider<ServletRegistrationBean<?>> servletRegistrations, ObjectProvider<ApiVersionResolver> apiVersionResolvers, ObjectProvider<ApiVersionParser<?>> apiVersionParser, ObjectProvider<ApiVersionDeprecationHandler> apiVersionDeprecationHandler) {
            this.resourceProperties = webProperties.getResources();
            this.mvcProperties = mvcProperties;
            this.beanFactory = beanFactory;
            this.httpMessageConvertersCustomizerProvider = httpMessageConvertersCustomizerProvider;
            this.resourceHandlerRegistrationCustomizer = (ResourceHandlerRegistrationCustomizer)resourceHandlerRegistrationCustomizerProvider.getIfAvailable();
            this.dispatcherServletPath = dispatcherServletPath;
            this.servletRegistrations = servletRegistrations;
            this.apiVersionResolvers = apiVersionResolvers;
            this.apiVersionParser = apiVersionParser;
            this.apiVersionDeprecationHandler = apiVersionDeprecationHandler;
        }

        public void setServletContext(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public void configureMessageConverters(HttpMessageConverters.ServerBuilder builder) {
            this.httpMessageConvertersCustomizerProvider.orderedStream().forEach(customizer -> customizer.customize(builder));
        }

        public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
            Duration timeout;
            Object taskExecutor;
            if (this.beanFactory.containsBean("applicationTaskExecutor") && (taskExecutor = this.beanFactory.getBean("applicationTaskExecutor")) instanceof AsyncTaskExecutor) {
                AsyncTaskExecutor asyncTaskExecutor = (AsyncTaskExecutor)taskExecutor;
                configurer.setTaskExecutor(asyncTaskExecutor);
            }
            if ((timeout = this.mvcProperties.getAsync().getRequestTimeout()) != null) {
                configurer.setDefaultTimeout(timeout.toMillis());
            }
        }

        public void configurePathMatch(PathMatchConfigurer configurer) {
            if (this.mvcProperties.getPathmatch().getMatchingStrategy() == WebMvcProperties.MatchingStrategy.ANT_PATH_MATCHER) {
                configurer.setPathMatcher((PathMatcher)new AntPathMatcher());
                this.dispatcherServletPath.ifAvailable(dispatcherPath -> {
                    String servletUrlMapping = dispatcherPath.getServletUrlMapping();
                    if (servletUrlMapping.equals(WebMvcAutoConfiguration.SERVLET_LOCATION) && this.singleDispatcherServlet()) {
                        UrlPathHelper urlPathHelper = new UrlPathHelper();
                        urlPathHelper.setAlwaysUseFullPath(true);
                        configurer.setUrlPathHelper(urlPathHelper);
                    }
                });
            }
        }

        private boolean singleDispatcherServlet() {
            return this.servletRegistrations.stream().map(ServletRegistrationBean::getServlet).filter(DispatcherServlet.class::isInstance).count() == 1L;
        }

        public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
            WebMvcProperties.Contentnegotiation contentnegotiation = this.mvcProperties.getContentnegotiation();
            configurer.favorParameter(contentnegotiation.isFavorParameter());
            if (contentnegotiation.getParameterName() != null) {
                configurer.parameterName(contentnegotiation.getParameterName());
            }
            Map<String, MediaType> mediaTypes = contentnegotiation.getMediaTypes();
            mediaTypes.forEach((arg_0, arg_1) -> ((ContentNegotiationConfigurer)configurer).mediaType(arg_0, arg_1));
            List<MediaType> defaultContentTypes = contentnegotiation.getDefaultContentTypes();
            if (!CollectionUtils.isEmpty(defaultContentTypes)) {
                configurer.defaultContentType(defaultContentTypes.toArray(new MediaType[0]));
            }
        }

        @Bean
        @ConditionalOnMissingBean
        InternalResourceViewResolver defaultViewResolver() {
            InternalResourceViewResolver resolver = new InternalResourceViewResolver();
            resolver.setPrefix(this.mvcProperties.getView().getPrefix());
            resolver.setSuffix(this.mvcProperties.getView().getSuffix());
            return resolver;
        }

        @Bean
        @ConditionalOnBean(value={View.class})
        @ConditionalOnMissingBean
        BeanNameViewResolver beanNameViewResolver() {
            BeanNameViewResolver resolver = new BeanNameViewResolver();
            resolver.setOrder(0x7FFFFFF5);
            return resolver;
        }

        @Bean
        @ConditionalOnBean(value={ViewResolver.class})
        @ConditionalOnMissingBean(name={"viewResolver"}, value={ContentNegotiatingViewResolver.class})
        ContentNegotiatingViewResolver viewResolver(BeanFactory beanFactory) {
            ContentNegotiatingViewResolver resolver = new ContentNegotiatingViewResolver();
            resolver.setContentNegotiationManager((ContentNegotiationManager)beanFactory.getBean(ContentNegotiationManager.class));
            resolver.setOrder(Integer.MIN_VALUE);
            return resolver;
        }

        public @Nullable MessageCodesResolver getMessageCodesResolver() {
            if (this.mvcProperties.getMessageCodesResolverFormat() != null) {
                DefaultMessageCodesResolver resolver = new DefaultMessageCodesResolver();
                resolver.setMessageCodeFormatter((MessageCodeFormatter)this.mvcProperties.getMessageCodesResolverFormat());
                return resolver;
            }
            return null;
        }

        public void addFormatters(FormatterRegistry registry) {
            ApplicationConversionService.addBeans((FormatterRegistry)registry, (ListableBeanFactory)this.beanFactory);
        }

        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            if (!this.resourceProperties.isAddMappings()) {
                logger.debug((Object)"Default resource handling disabled");
                return;
            }
            this.addResourceHandler(registry, this.mvcProperties.getWebjarsPathPattern(), "classpath:/META-INF/resources/webjars/");
            this.addResourceHandler(registry, this.mvcProperties.getStaticPathPattern(), (ResourceHandlerRegistration registration) -> {
                registration.addResourceLocations(this.resourceProperties.getStaticLocations());
                if (this.servletContext != null) {
                    ServletContextResource resource = new ServletContextResource(this.servletContext, WebMvcAutoConfiguration.SERVLET_LOCATION);
                    registration.addResourceLocations(new Resource[]{resource});
                }
            });
        }

        private void addResourceHandler(ResourceHandlerRegistry registry, String pattern, String ... locations) {
            this.addResourceHandler(registry, pattern, (ResourceHandlerRegistration registration) -> registration.addResourceLocations(locations));
        }

        private void addResourceHandler(ResourceHandlerRegistry registry, String pattern, Consumer<ResourceHandlerRegistration> customizer) {
            CacheControl cacheControl;
            if (registry.hasMappingForPattern(pattern)) {
                return;
            }
            ResourceHandlerRegistration registration = registry.addResourceHandler(new String[]{pattern});
            customizer.accept(registration);
            Integer cachePeriod = this.getSeconds(this.resourceProperties.getCache().getPeriod());
            if (cachePeriod != null) {
                registration.setCachePeriod(cachePeriod);
            }
            if ((cacheControl = this.resourceProperties.getCache().getCachecontrol().toHttpCacheControl()) != null) {
                registration.setCacheControl(cacheControl);
            }
            registration.setUseLastModified(this.resourceProperties.getCache().isUseLastModified());
            this.customizeResourceHandlerRegistration(registration);
        }

        @Contract(value="!null -> !null")
        private @Nullable Integer getSeconds(@Nullable Duration cachePeriod) {
            return cachePeriod != null ? Integer.valueOf((int)cachePeriod.getSeconds()) : null;
        }

        private void customizeResourceHandlerRegistration(ResourceHandlerRegistration registration) {
            if (this.resourceHandlerRegistrationCustomizer != null) {
                this.resourceHandlerRegistrationCustomizer.customize(registration);
            }
        }

        public void configureApiVersioning(ApiVersionConfigurer configurer) {
            PropertyMapper map = PropertyMapper.get();
            WebMvcProperties.Apiversion properties = this.mvcProperties.getApiversion();
            map.from(properties::getRequired).to(arg_0 -> ((ApiVersionConfigurer)configurer).setVersionRequired(arg_0));
            map.from(properties::getDefaultVersion).to(arg_0 -> ((ApiVersionConfigurer)configurer).setDefaultVersion(arg_0));
            map.from(properties::getSupported).to(supported -> {
                ApiVersionConfigurer apiVersionConfigurer = configurer;
                Objects.requireNonNull(apiVersionConfigurer);
                ApiVersionConfigurer rec$ = apiVersionConfigurer;
                supported.forEach(xva$0 -> rec$.addSupportedVersions(new String[]{xva$0}));
            });
            map.from(properties::getDetectSupported).to(arg_0 -> ((ApiVersionConfigurer)configurer).detectSupportedVersions(arg_0));
            this.configureApiVersioningUse(configurer, properties.getUse());
            Stream stream = this.apiVersionResolvers.orderedStream();
            ApiVersionConfigurer apiVersionConfigurer = configurer;
            Objects.requireNonNull(apiVersionConfigurer);
            ApiVersionConfigurer apiVersionConfigurer2 = apiVersionConfigurer;
            stream.forEach(xva$0 -> apiVersionConfigurer2.useVersionResolver(new ApiVersionResolver[]{xva$0}));
            this.apiVersionParser.ifAvailable(arg_0 -> ((ApiVersionConfigurer)configurer).setVersionParser(arg_0));
            this.apiVersionDeprecationHandler.ifAvailable(arg_0 -> ((ApiVersionConfigurer)configurer).setDeprecationHandler(arg_0));
        }

        private void configureApiVersioningUse(ApiVersionConfigurer configurer, WebMvcProperties.Apiversion.Use use) {
            PropertyMapper map = PropertyMapper.get();
            map.from(use::getHeader).whenHasText().to(arg_0 -> ((ApiVersionConfigurer)configurer).useRequestHeader(arg_0));
            map.from(use::getQueryParameter).whenHasText().to(arg_0 -> ((ApiVersionConfigurer)configurer).useQueryParam(arg_0));
            map.from(use::getPathSegment).to(arg_0 -> ((ApiVersionConfigurer)configurer).usePathSegment(arg_0));
            use.getMediaTypeParameter().forEach((arg_0, arg_1) -> ((ApiVersionConfigurer)configurer).useMediaTypeParameter(arg_0, arg_1));
        }

        @Bean
        @ConditionalOnMissingBean(value={RequestContextListener.class, RequestContextFilter.class})
        @ConditionalOnMissingFilterBean
        static RequestContextFilter requestContextFilter() {
            return new OrderedRequestContextFilter();
        }
    }
}

