/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webmvc.autoconfigure.error;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.webmvc.autoconfigure.error.AbstractErrorController;
import org.springframework.boot.webmvc.autoconfigure.error.ErrorViewResolver;
import org.springframework.boot.webmvc.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"${server.error.path:${error.path:/error}}"})
public class BasicErrorController
extends AbstractErrorController {
    private final ErrorProperties errorProperties;

    public BasicErrorController(ErrorAttributes errorAttributes, ErrorProperties errorProperties) {
        this(errorAttributes, errorProperties, Collections.emptyList());
    }

    public BasicErrorController(ErrorAttributes errorAttributes, ErrorProperties errorProperties, List<ErrorViewResolver> errorViewResolvers) {
        super(errorAttributes, errorViewResolvers);
        Assert.notNull((Object)errorProperties, (String)"'errorProperties' must not be null");
        this.errorProperties = errorProperties;
    }

    @RequestMapping(produces={"text/html"})
    public ModelAndView errorHtml(HttpServletRequest request, HttpServletResponse response) {
        HttpStatus status = this.getStatus(request);
        Map<String, Object> model = Collections.unmodifiableMap(this.getErrorAttributes(request, this.getErrorAttributeOptions(request, MediaType.TEXT_HTML)));
        response.setStatus(status.value());
        ModelAndView modelAndView = this.resolveErrorView(request, response, status, model);
        return modelAndView != null ? modelAndView : new ModelAndView("error", model);
    }

    @RequestMapping
    public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
        HttpStatus status = this.getStatus(request);
        if (status == HttpStatus.NO_CONTENT) {
            return new ResponseEntity((HttpStatusCode)status);
        }
        Map<String, Object> body = this.getErrorAttributes(request, this.getErrorAttributeOptions(request, MediaType.ALL));
        return new ResponseEntity(body, (HttpStatusCode)status);
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    public ResponseEntity<String> mediaTypeNotAcceptable(HttpServletRequest request) {
        HttpStatus status = this.getStatus(request);
        return ResponseEntity.status((HttpStatusCode)status).build();
    }

    protected ErrorAttributeOptions getErrorAttributeOptions(HttpServletRequest request, MediaType mediaType) {
        ErrorAttributeOptions options = ErrorAttributeOptions.defaults();
        if (this.errorProperties.isIncludeException()) {
            options = options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.EXCEPTION});
        }
        if (this.isIncludeStackTrace(request, mediaType)) {
            options = options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.STACK_TRACE});
        }
        if (this.isIncludeMessage(request, mediaType)) {
            options = options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.MESSAGE});
        }
        if (this.isIncludeBindingErrors(request, mediaType)) {
            options = options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.BINDING_ERRORS});
        }
        options = this.isIncludePath(request, mediaType) ? options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.PATH}) : options.excluding(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.PATH});
        return options;
    }

    protected boolean isIncludeStackTrace(HttpServletRequest request, MediaType produces) {
        return switch (this.getErrorProperties().getIncludeStacktrace()) {
            default -> throw new IncompatibleClassChangeError();
            case ErrorProperties.IncludeAttribute.ALWAYS -> true;
            case ErrorProperties.IncludeAttribute.ON_PARAM -> this.getTraceParameter(request);
            case ErrorProperties.IncludeAttribute.NEVER -> false;
        };
    }

    protected boolean isIncludeMessage(HttpServletRequest request, MediaType produces) {
        return switch (this.getErrorProperties().getIncludeMessage()) {
            default -> throw new IncompatibleClassChangeError();
            case ErrorProperties.IncludeAttribute.ALWAYS -> true;
            case ErrorProperties.IncludeAttribute.ON_PARAM -> this.getMessageParameter(request);
            case ErrorProperties.IncludeAttribute.NEVER -> false;
        };
    }

    protected boolean isIncludeBindingErrors(HttpServletRequest request, MediaType produces) {
        return switch (this.getErrorProperties().getIncludeBindingErrors()) {
            default -> throw new IncompatibleClassChangeError();
            case ErrorProperties.IncludeAttribute.ALWAYS -> true;
            case ErrorProperties.IncludeAttribute.ON_PARAM -> this.getErrorsParameter(request);
            case ErrorProperties.IncludeAttribute.NEVER -> false;
        };
    }

    protected boolean isIncludePath(HttpServletRequest request, MediaType produces) {
        return switch (this.getErrorProperties().getIncludePath()) {
            default -> throw new IncompatibleClassChangeError();
            case ErrorProperties.IncludeAttribute.ALWAYS -> true;
            case ErrorProperties.IncludeAttribute.ON_PARAM -> this.getPathParameter(request);
            case ErrorProperties.IncludeAttribute.NEVER -> false;
        };
    }

    protected ErrorProperties getErrorProperties() {
        return this.errorProperties;
    }
}

