/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webmvc.test.autoconfigure;

import org.htmlunit.BrowserVersion;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.test.web.htmlunit.UriBuilderFactoryWebConnectionHtmlUnitDriver;
import org.springframework.boot.webmvc.test.autoconfigure.MockMvcAutoConfiguration;
import org.springframework.boot.webmvc.test.autoconfigure.MockMvcHtmlUnitDriverCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.htmlunit.webdriver.MockMvcHtmlUnitDriverBuilder;
import org.springframework.test.web.servlet.htmlunit.webdriver.WebConnectionHtmlUnitDriver;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilderFactory;

@AutoConfiguration(after={MockMvcAutoConfiguration.class})
@ConditionalOnClass(value={HtmlUnitDriver.class})
@ConditionalOnBooleanProperty(name={"spring.test.mockmvc.webdriver.enabled"}, matchIfMissing=true)
public final class MockMvcWebDriverAutoConfiguration {
    private static final UriBuilderFactory MOCK_URI_BUILDER_FACTORY = new DefaultUriBuilderFactory("http://localhost");

    @Bean
    @ConditionalOnMissingBean(value={WebDriver.class, MockMvcHtmlUnitDriverBuilder.class})
    @ConditionalOnBean(value={MockMvc.class})
    MockMvcHtmlUnitDriverBuilder mockMvcHtmlUnitDriverBuilder(MockMvc mockMvc) {
        return MockMvcHtmlUnitDriverBuilder.mockMvcSetup((MockMvc)mockMvc).withDelegate((WebConnectionHtmlUnitDriver)new UriBuilderFactoryWebConnectionHtmlUnitDriver(MOCK_URI_BUILDER_FACTORY, BrowserVersion.CHROME));
    }

    @Bean
    @ConditionalOnMissingBean(value={WebDriver.class})
    @ConditionalOnBean(value={MockMvcHtmlUnitDriverBuilder.class})
    HtmlUnitDriver htmlUnitDriver(MockMvcHtmlUnitDriverBuilder builder, ObjectProvider<MockMvcHtmlUnitDriverCustomizer> customizers) {
        HtmlUnitDriver driver = builder.build();
        customizers.orderedStream().forEach(customizer -> customizer.customize(driver));
        return driver;
    }
}

