/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webflux.actuate.web.mappings;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.reactive.result.condition.MediaTypeExpression;
import org.springframework.web.reactive.result.condition.NameValueExpression;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import org.springframework.web.util.pattern.PathPattern;

public class RequestMappingConditionsDescription {
    private final List<MediaTypeExpressionDescription> consumes;
    private final List<NameValueExpressionDescription> headers;
    private final Set<RequestMethod> methods;
    private final List<NameValueExpressionDescription> params;
    private final Set<String> patterns;
    private final List<MediaTypeExpressionDescription> produces;

    RequestMappingConditionsDescription(RequestMappingInfo requestMapping) {
        this.consumes = requestMapping.getConsumesCondition().getExpressions().stream().map(MediaTypeExpressionDescription::new).toList();
        this.headers = requestMapping.getHeadersCondition().getExpressions().stream().map(NameValueExpressionDescription::new).toList();
        this.methods = requestMapping.getMethodsCondition().getMethods();
        this.params = requestMapping.getParamsCondition().getExpressions().stream().map(NameValueExpressionDescription::new).toList();
        this.patterns = requestMapping.getPatternsCondition().getPatterns().stream().map(PathPattern::getPatternString).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
        this.produces = requestMapping.getProducesCondition().getExpressions().stream().map(MediaTypeExpressionDescription::new).toList();
    }

    public List<MediaTypeExpressionDescription> getConsumes() {
        return this.consumes;
    }

    public List<NameValueExpressionDescription> getHeaders() {
        return this.headers;
    }

    public Set<RequestMethod> getMethods() {
        return this.methods;
    }

    public List<NameValueExpressionDescription> getParams() {
        return this.params;
    }

    public Set<String> getPatterns() {
        return this.patterns;
    }

    public List<MediaTypeExpressionDescription> getProduces() {
        return this.produces;
    }

    public static class NameValueExpressionDescription {
        private final String name;
        private final @Nullable Object value;
        private final boolean negated;

        NameValueExpressionDescription(NameValueExpression<?> expression) {
            this.name = expression.getName();
            this.value = expression.getValue();
            this.negated = expression.isNegated();
        }

        public String getName() {
            return this.name;
        }

        public @Nullable Object getValue() {
            return this.value;
        }

        public boolean isNegated() {
            return this.negated;
        }
    }

    public static class MediaTypeExpressionDescription {
        private final String mediaType;
        private final boolean negated;

        MediaTypeExpressionDescription(MediaTypeExpression expression) {
            this.mediaType = expression.getMediaType().toString();
            this.negated = expression.isNegated();
        }

        public String getMediaType() {
            return this.mediaType;
        }

        public boolean isNegated() {
            return this.negated;
        }
    }
}

