/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webflux.autoconfigure.actuate.web;

import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextType;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementWebServerFactoryCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.server.ConfigurableWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.http.server.reactive.ContextPathCompositeHandler;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.reactive.config.EnableWebFlux;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;

@ManagementContextConfiguration(value=ManagementContextType.CHILD, proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={DispatcherHandler.class})
@EnableWebFlux
class WebFluxManagementChildContextConfiguration {
    WebFluxManagementChildContextConfiguration() {
    }

    @Bean
    ManagementWebServerFactoryCustomizer<ConfigurableWebServerFactory> reactiveManagementWebServerFactoryCustomizer(ListableBeanFactory beanFactory) {
        return new ManagementWebServerFactoryCustomizer(beanFactory);
    }

    @Bean
    HttpHandler httpHandler(ApplicationContext applicationContext, ManagementServerProperties properties) {
        HttpHandler httpHandler = WebHttpHandlerBuilder.applicationContext((ApplicationContext)applicationContext).build();
        if (StringUtils.hasText((String)properties.getBasePath())) {
            Map<String, HttpHandler> handlersMap = Collections.singletonMap(properties.getBasePath(), httpHandler);
            return new ContextPathCompositeHandler(handlersMap);
        }
        return httpHandler;
    }
}

