/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webflux.autoconfigure;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.Name;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.webflux")
public class WebFluxProperties {
    private @Nullable String basePath;
    private final Format format = new Format();
    private final Problemdetails problemdetails = new Problemdetails();
    private final Apiversion apiversion = new Apiversion();
    private String staticPathPattern = "/**";
    private String webjarsPathPattern = "/webjars/**";

    public @Nullable String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(@Nullable String basePath) {
        this.basePath = this.cleanBasePath(basePath);
    }

    private @Nullable String cleanBasePath(@Nullable String basePath) {
        Object candidate = null;
        if (StringUtils.hasLength((String)basePath)) {
            candidate = basePath.strip();
        }
        if (StringUtils.hasText(candidate)) {
            if (!((String)candidate).startsWith("/")) {
                candidate = "/" + (String)candidate;
            }
            if (((String)candidate).endsWith("/")) {
                candidate = ((String)candidate).substring(0, ((String)candidate).length() - 1);
            }
        }
        return candidate;
    }

    public Format getFormat() {
        return this.format;
    }

    public Problemdetails getProblemdetails() {
        return this.problemdetails;
    }

    public Apiversion getApiversion() {
        return this.apiversion;
    }

    public String getStaticPathPattern() {
        return this.staticPathPattern;
    }

    public void setStaticPathPattern(String staticPathPattern) {
        this.staticPathPattern = staticPathPattern;
    }

    public String getWebjarsPathPattern() {
        return this.webjarsPathPattern;
    }

    public void setWebjarsPathPattern(String webjarsPathPattern) {
        this.webjarsPathPattern = webjarsPathPattern;
    }

    public static class Format {
        private @Nullable String date;
        private @Nullable String time;
        private @Nullable String dateTime;

        public @Nullable String getDate() {
            return this.date;
        }

        public void setDate(@Nullable String date) {
            this.date = date;
        }

        public @Nullable String getTime() {
            return this.time;
        }

        public void setTime(@Nullable String time) {
            this.time = time;
        }

        public @Nullable String getDateTime() {
            return this.dateTime;
        }

        public void setDateTime(@Nullable String dateTime) {
            this.dateTime = dateTime;
        }
    }

    public static class Problemdetails {
        private boolean enabled = false;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Apiversion {
        private @Nullable Boolean required;
        @Name(value="default")
        private @Nullable String defaultVersion;
        private @Nullable List<String> supported;
        private @Nullable Boolean detectSupported;
        private final Use use = new Use();

        public @Nullable Boolean getRequired() {
            return this.required;
        }

        public void setRequired(@Nullable Boolean required) {
            this.required = required;
        }

        public @Nullable String getDefaultVersion() {
            return this.defaultVersion;
        }

        public void setDefaultVersion(@Nullable String defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        public @Nullable List<String> getSupported() {
            return this.supported;
        }

        public void setSupported(@Nullable List<String> supported) {
            this.supported = supported;
        }

        public @Nullable Boolean getDetectSupported() {
            return this.detectSupported;
        }

        public void setDetectSupported(@Nullable Boolean detectSupported) {
            this.detectSupported = detectSupported;
        }

        public Use getUse() {
            return this.use;
        }

        public static class Use {
            private @Nullable String header;
            private @Nullable String queryParameter;
            private @Nullable Integer pathSegment;
            private Map<MediaType, String> mediaTypeParameter = new LinkedHashMap<MediaType, String>();

            public @Nullable String getHeader() {
                return this.header;
            }

            public void setHeader(@Nullable String header) {
                this.header = header;
            }

            public @Nullable String getQueryParameter() {
                return this.queryParameter;
            }

            public void setQueryParameter(@Nullable String queryParameter) {
                this.queryParameter = queryParameter;
            }

            public @Nullable Integer getPathSegment() {
                return this.pathSegment;
            }

            public void setPathSegment(@Nullable Integer pathSegment) {
                this.pathSegment = pathSegment;
            }

            public Map<MediaType, String> getMediaTypeParameter() {
                return this.mediaTypeParameter;
            }

            public void setMediaTypeParameter(Map<MediaType, String> mediaTypeParameter) {
                this.mediaTypeParameter = mediaTypeParameter;
            }
        }
    }
}

