/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webflux.test.autoconfigure;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.test.context.filter.annotation.StandardAnnotationCustomizableTypeExcludeFilter;
import org.springframework.boot.webflux.test.autoconfigure.WebFluxTest;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Controller;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.server.WebExceptionHandler;
import org.springframework.web.server.WebFilter;

class WebFluxTypeExcludeFilter
extends StandardAnnotationCustomizableTypeExcludeFilter<WebFluxTest> {
    private static final Class<?>[] NO_CONTROLLERS = new Class[0];
    private static final String[] OPTIONAL_INCLUDES = new String[]{"tools.jackson.databind.JacksonModule", "org.springframework.boot.jackson.JsonComponent"};
    private static final Set<Class<?>> KNOWN_INCLUDES;
    private static final Set<Class<?>> KNOWN_INCLUDES_AND_CONTROLLER;
    private final Class<?>[] controllers = this.getAnnotation().getValue("controllers", Class[].class).orElse(NO_CONTROLLERS);

    WebFluxTypeExcludeFilter(Class<?> testClass) {
        super(testClass);
    }

    protected Set<Class<?>> getKnownIncludes() {
        if (ObjectUtils.isEmpty((Object[])this.controllers)) {
            return KNOWN_INCLUDES_AND_CONTROLLER;
        }
        return KNOWN_INCLUDES;
    }

    protected Set<Class<?>> getComponentIncludes() {
        return new LinkedHashSet(Arrays.asList(this.controllers));
    }

    static {
        LinkedHashSet<Object> includes = new LinkedHashSet<Class>();
        includes.add(ControllerAdvice.class);
        includes.add(WebFluxConfigurer.class);
        includes.add(Converter.class);
        includes.add(GenericConverter.class);
        includes.add(WebExceptionHandler.class);
        includes.add(WebFilter.class);
        for (String optionalInclude : OPTIONAL_INCLUDES) {
            try {
                includes.add(ClassUtils.forName((String)optionalInclude, null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        KNOWN_INCLUDES = Collections.unmodifiableSet(includes);
        includes = new LinkedHashSet(KNOWN_INCLUDES);
        includes.add(Controller.class);
        KNOWN_INCLUDES_AND_CONTROLLER = Collections.unmodifiableSet(includes);
    }
}

