/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webclient.autoconfigure.service;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.http.client.HttpClientSettings;
import org.springframework.boot.http.client.autoconfigure.reactive.ReactiveHttpClientAutoConfiguration;
import org.springframework.boot.http.client.autoconfigure.service.HttpServiceClientProperties;
import org.springframework.boot.http.client.autoconfigure.service.HttpServiceClientPropertiesAutoConfiguration;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorBuilder;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.webclient.WebClientCustomizer;
import org.springframework.boot.webclient.autoconfigure.WebClientAutoConfiguration;
import org.springframework.boot.webclient.autoconfigure.service.PropertiesWebClientHttpServiceGroupConfigurer;
import org.springframework.boot.webclient.autoconfigure.service.WebClientCustomizerHttpServiceGroupConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.reactive.function.client.support.WebClientAdapter;
import org.springframework.web.service.registry.HttpServiceProxyRegistry;

@AutoConfiguration(after={HttpServiceClientPropertiesAutoConfiguration.class, ReactiveHttpClientAutoConfiguration.class, WebClientAutoConfiguration.class})
@ConditionalOnClass(value={WebClientAdapter.class})
@ConditionalOnBean(value={HttpServiceProxyRegistry.class})
public final class ReactiveHttpServiceClientAutoConfiguration {
    @Bean
    PropertiesWebClientHttpServiceGroupConfigurer webClientPropertiesHttpServiceGroupConfigurer(ResourceLoader resourceLoader, HttpServiceClientProperties properties, ObjectProvider<SslBundles> sslBundles, ObjectProvider<ClientHttpConnectorBuilder<?>> clientConnectorBuilder, ObjectProvider<HttpClientSettings> httpClientSettings) {
        return new PropertiesWebClientHttpServiceGroupConfigurer(resourceLoader.getClassLoader(), properties, (SslBundles)sslBundles.getIfAvailable(), clientConnectorBuilder, (HttpClientSettings)httpClientSettings.getIfAvailable());
    }

    @Bean
    WebClientCustomizerHttpServiceGroupConfigurer webClientCustomizerHttpServiceGroupConfigurer(ObjectProvider<WebClientCustomizer> customizers) {
        return new WebClientCustomizerHttpServiceGroupConfigurer(customizers);
    }
}

