/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webclient.autoconfigure.service;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.http.client.autoconfigure.reactive.AbstractClientHttpConnectorProperties;
import org.springframework.boot.http.client.autoconfigure.reactive.ClientHttpConnectors;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorBuilder;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorSettings;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.webclient.autoconfigure.PropertiesWebClientCustomizer;
import org.springframework.boot.webclient.autoconfigure.service.ReactiveHttpClientServiceProperties;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.web.client.ApiVersionFormatter;
import org.springframework.web.client.ApiVersionInserter;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.support.WebClientHttpServiceGroupConfigurer;
import org.springframework.web.service.registry.HttpServiceGroup;
import org.springframework.web.service.registry.HttpServiceGroupConfigurer;

class WebClientPropertiesHttpServiceGroupConfigurer
implements WebClientHttpServiceGroupConfigurer {
    private final ClassLoader classLoader;
    private final ObjectProvider<SslBundles> sslBundles;
    private final ReactiveHttpClientServiceProperties serviceProperties;
    private final ObjectProvider<ClientHttpConnectorBuilder<?>> clientConnectorBuilder;
    private final ObjectProvider<ClientHttpConnectorSettings> clientConnectorSettings;
    private final @Nullable ApiVersionInserter apiVersionInserter;
    private final @Nullable ApiVersionFormatter apiVersionFormatter;

    WebClientPropertiesHttpServiceGroupConfigurer(ClassLoader classLoader, ObjectProvider<SslBundles> sslBundles, ReactiveHttpClientServiceProperties serviceProperties, ObjectProvider<ClientHttpConnectorBuilder<?>> clientConnectorBuilder, ObjectProvider<ClientHttpConnectorSettings> clientConnectorSettings, ObjectProvider<ApiVersionInserter> apiVersionInserter, ObjectProvider<ApiVersionFormatter> apiVersionFormatter) {
        this.classLoader = classLoader;
        this.sslBundles = sslBundles;
        this.serviceProperties = serviceProperties;
        this.clientConnectorBuilder = clientConnectorBuilder;
        this.clientConnectorSettings = clientConnectorSettings;
        this.apiVersionInserter = (ApiVersionInserter)apiVersionInserter.getIfAvailable();
        this.apiVersionFormatter = (ApiVersionFormatter)apiVersionFormatter.getIfAvailable();
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void configureGroups(HttpServiceGroupConfigurer.Groups<WebClient.Builder> groups) {
        groups.forEachClient(this::configureClient);
    }

    private void configureClient(HttpServiceGroup group, WebClient.Builder builder) {
        ReactiveHttpClientServiceProperties.Group groupProperties = this.serviceProperties.getGroup().get(group.name());
        builder.clientConnector(this.getClientConnector(groupProperties));
        this.getPropertiesWebClientCustomizer(groupProperties).customize(builder);
    }

    private PropertiesWebClientCustomizer getPropertiesWebClientCustomizer(@Nullable ReactiveHttpClientServiceProperties.Group groupProperties) {
        return new PropertiesWebClientCustomizer(this.apiVersionInserter, this.apiVersionFormatter, groupProperties, this.serviceProperties);
    }

    private ClientHttpConnector getClientConnector(@Nullable ReactiveHttpClientServiceProperties.Group groupProperties) {
        ClientHttpConnectors connectors = new ClientHttpConnectors((ClientHttpConnectorBuilder)this.clientConnectorBuilder.getIfAvailable(), (ClientHttpConnectorSettings)this.clientConnectorSettings.getIfAvailable(), this.sslBundles, new AbstractClientHttpConnectorProperties[]{groupProperties, this.serviceProperties});
        ClientHttpConnectorBuilder builder = connectors.builder(this.classLoader);
        ClientHttpConnectorSettings settings = connectors.settings();
        return builder.build(settings);
    }
}

