/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webclient.autoconfigure;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.http.client.autoconfigure.reactive.ClientHttpConnectorAutoConfiguration;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorBuilder;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorSettings;
import org.springframework.boot.http.codec.CodecCustomizer;
import org.springframework.boot.http.codec.autoconfigure.CodecsAutoConfiguration;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.webclient.WebClientCustomizer;
import org.springframework.boot.webclient.autoconfigure.AutoConfiguredWebClientSsl;
import org.springframework.boot.webclient.autoconfigure.PropertiesWebClientCustomizer;
import org.springframework.boot.webclient.autoconfigure.WebClientCodecCustomizer;
import org.springframework.boot.webclient.autoconfigure.WebClientProperties;
import org.springframework.boot.webclient.autoconfigure.WebClientSsl;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.Order;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.web.client.ApiVersionFormatter;
import org.springframework.web.client.ApiVersionInserter;
import org.springframework.web.reactive.function.client.WebClient;

@AutoConfiguration(after={ClientHttpConnectorAutoConfiguration.class, CodecsAutoConfiguration.class})
@ConditionalOnClass(value={WebClient.class})
@EnableConfigurationProperties(value={WebClientProperties.class})
public final class WebClientAutoConfiguration {
    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    WebClient.Builder webClientBuilder(ObjectProvider<WebClientCustomizer> customizerProvider, ObjectProvider<ApiVersionInserter> apiVersionInserter, ObjectProvider<ApiVersionFormatter> apiVersionFormatter, WebClientProperties webClientProperties) {
        WebClient.Builder builder = WebClient.builder();
        PropertiesWebClientCustomizer propertiesCustomizer = new PropertiesWebClientCustomizer((ApiVersionInserter)apiVersionInserter.getIfAvailable(), (ApiVersionFormatter)apiVersionFormatter.getIfAvailable(), webClientProperties);
        propertiesCustomizer.customize(builder);
        customizerProvider.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder;
    }

    @Bean
    @Lazy
    @Order(value=0)
    @ConditionalOnBean(value={ClientHttpConnector.class})
    WebClientCustomizer webClientHttpConnectorCustomizer(ClientHttpConnector clientHttpConnector) {
        return builder -> builder.clientConnector(clientHttpConnector);
    }

    @Bean
    @ConditionalOnMissingBean(value={WebClientSsl.class})
    @ConditionalOnBean(value={SslBundles.class})
    AutoConfiguredWebClientSsl webClientSsl(ClientHttpConnectorBuilder<?> clientHttpConnectorBuilder, ClientHttpConnectorSettings clientHttpConnectorSettings, SslBundles sslBundles) {
        return new AutoConfiguredWebClientSsl(clientHttpConnectorBuilder, clientHttpConnectorSettings, sslBundles);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={CodecCustomizer.class})
    protected static class WebClientCodecsConfiguration {
        protected WebClientCodecsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @Order(value=0)
        WebClientCodecCustomizer exchangeStrategiesCustomizer(ObjectProvider<CodecCustomizer> codecCustomizers) {
            return new WebClientCodecCustomizer(codecCustomizers.orderedStream().toList());
        }
    }
}

