/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.web.error.ErrorPage;
import org.springframework.boot.web.server.Compression;
import org.springframework.boot.web.server.ConfigurableWebServerFactory;
import org.springframework.boot.web.server.Http2;
import org.springframework.boot.web.server.Shutdown;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.boot.web.server.WebServerSslBundle;
import org.springframework.util.Assert;
import org.springframework.util.FileSystemUtils;

public abstract class AbstractConfigurableWebServerFactory
implements ConfigurableWebServerFactory {
    private int port = 8080;
    private @Nullable InetAddress address;
    private Set<ErrorPage> errorPages = new LinkedHashSet<ErrorPage>();
    private @Nullable Ssl ssl;
    private @Nullable SslBundles sslBundles;
    private @Nullable Http2 http2;
    private @Nullable Compression compression;
    private @Nullable String serverHeader;
    private Shutdown shutdown = Shutdown.IMMEDIATE;

    public AbstractConfigurableWebServerFactory() {
    }

    public AbstractConfigurableWebServerFactory(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    public @Nullable InetAddress getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(@Nullable InetAddress address) {
        this.address = address;
    }

    public Set<ErrorPage> getErrorPages() {
        return this.errorPages;
    }

    @Override
    public void setErrorPages(Set<? extends ErrorPage> errorPages) {
        Assert.notNull(errorPages, (String)"'errorPages' must not be null");
        this.errorPages = new LinkedHashSet<ErrorPage>(errorPages);
    }

    public void addErrorPages(ErrorPage ... errorPages) {
        Assert.notNull((Object)errorPages, (String)"'errorPages' must not be null");
        this.errorPages.addAll(Arrays.asList(errorPages));
    }

    public @Nullable Ssl getSsl() {
        return this.ssl;
    }

    @Override
    public void setSsl(@Nullable Ssl ssl) {
        this.ssl = ssl;
    }

    public @Nullable SslBundles getSslBundles() {
        return this.sslBundles;
    }

    @Override
    public void setSslBundles(@Nullable SslBundles sslBundles) {
        this.sslBundles = sslBundles;
    }

    public @Nullable Http2 getHttp2() {
        return this.http2;
    }

    @Override
    public void setHttp2(@Nullable Http2 http2) {
        this.http2 = http2;
    }

    public @Nullable Compression getCompression() {
        return this.compression;
    }

    @Override
    public void setCompression(@Nullable Compression compression) {
        this.compression = compression;
    }

    public @Nullable String getServerHeader() {
        return this.serverHeader;
    }

    @Override
    public void setServerHeader(@Nullable String serverHeader) {
        this.serverHeader = serverHeader;
    }

    @Override
    public void setShutdown(Shutdown shutdown) {
        this.shutdown = shutdown;
    }

    public Shutdown getShutdown() {
        return this.shutdown;
    }

    protected final SslBundle getSslBundle() {
        return WebServerSslBundle.get(this.ssl, this.sslBundles);
    }

    protected final Map<String, SslBundle> getServerNameSslBundles() {
        Assert.state((this.ssl != null ? 1 : 0) != 0, (String)"'ssl' must not be null");
        return this.ssl.getServerNameBundles().stream().collect(Collectors.toMap(Ssl.ServerNameSslBundle::serverName, serverNameSslBundle -> {
            Assert.state((this.sslBundles != null ? 1 : 0) != 0, (String)"'sslBundles' must not be null");
            return this.sslBundles.getBundle(serverNameSslBundle.bundle());
        }));
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    protected final File createTempDir(String prefix) {
        try {
            File tempDir = Files.createTempDirectory(prefix + "." + this.getPort() + ".", new FileAttribute[0]).toFile();
            tempDir.deleteOnExit();
            return tempDir;
        }
        catch (IOException ex) {
            throw new WebServerException("Unable to create tempDir. java.io.tmpdir is set to " + System.getProperty("java.io.tmpdir"), ex);
        }
    }

    public static class TempDirs {
        private final Set<Path> dirs = new HashSet<Path>();
        private final int port;

        public TempDirs(int port) {
            this.port = port;
        }

        public Path createTempDir(String prefix) {
            try {
                Path directory = Files.createTempDirectory(prefix + "." + this.port + ".", new FileAttribute[0]).toAbsolutePath();
                this.dirs.add(directory);
                return directory;
            }
            catch (IOException ex) {
                throw new WebServerException("Unable to create tempDir. java.io.tmpdir is set to " + System.getProperty("java.io.tmpdir"), ex);
            }
        }

        public void cleanup() {
            for (Path dir : this.dirs) {
                try {
                    FileSystemUtils.deleteRecursively((Path)dir);
                }
                catch (IOException iOException) {}
            }
            this.dirs.clear();
        }
    }
}

