/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.tracing.docker.compose.otlp;

import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.tracing.autoconfigure.otlp.OtlpTracingConnectionDetails;
import org.springframework.boot.tracing.autoconfigure.otlp.Transport;

class OpenTelemetryTracingDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<OtlpTracingConnectionDetails> {
    private static final String[] OPENTELEMETRY_IMAGE_NAMES = new String[]{"otel/opentelemetry-collector-contrib", "grafana/otel-lgtm"};
    private static final int OTLP_GRPC_PORT = 4317;
    private static final int OTLP_HTTP_PORT = 4318;

    OpenTelemetryTracingDockerComposeConnectionDetailsFactory() {
        super(OPENTELEMETRY_IMAGE_NAMES, new String[]{"org.springframework.boot.tracing.autoconfigure.otlp.OtlpTracingAutoConfiguration"});
    }

    protected OtlpTracingConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new OpenTelemetryTracingDockerComposeConnectionDetails(source.getRunningService());
    }

    private static final class OpenTelemetryTracingDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements OtlpTracingConnectionDetails {
        private final String host;
        private final int grpcPort;
        private final int httpPort;

        private OpenTelemetryTracingDockerComposeConnectionDetails(RunningService source) {
            super(source);
            this.host = source.host();
            this.grpcPort = source.ports().get(4317);
            this.httpPort = source.ports().get(4318);
        }

        @Override
        public String getUrl(Transport transport) {
            int port = switch (transport) {
                default -> throw new IncompatibleClassChangeError();
                case Transport.HTTP -> this.httpPort;
                case Transport.GRPC -> this.grpcPort;
            };
            return "http://%s:%d/v1/traces".formatted(this.host, port);
        }
    }
}

