/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.tracing.autoconfigure.zipkin;

import brave.Tag;
import brave.Tags;
import brave.handler.MutableSpan;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.tracing.autoconfigure.ConditionalOnEnabledTracing;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import zipkin2.Span;
import zipkin2.reporter.BytesEncoder;
import zipkin2.reporter.BytesMessageSender;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.SpanBytesEncoder;
import zipkin2.reporter.brave.AsyncZipkinSpanHandler;
import zipkin2.reporter.brave.MutableSpanBytesEncoder;

@AutoConfiguration(afterName={"org.springframework.boot.zipkin.autoconfigure.ZipkinAutoConfiguration"})
@ConditionalOnClass(value={Encoding.class})
@Import(value={BraveConfiguration.class, OpenTelemetryConfiguration.class})
public class ZipkinTracingAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ZipkinSpanExporter.class, Span.class})
    static class OpenTelemetryConfiguration {
        OpenTelemetryConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={Encoding.class})
        @ConditionalOnMissingBean(value={Span.class}, parameterizedContainer={BytesEncoder.class})
        BytesEncoder<Span> spanBytesEncoder(Encoding encoding) {
            return SpanBytesEncoder.forEncoding((Encoding)encoding);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={BytesMessageSender.class})
        @ConditionalOnEnabledTracing(value="zipkin")
        ZipkinSpanExporter zipkinSpanExporter(BytesMessageSender sender, BytesEncoder<Span> spanBytesEncoder) {
            return ZipkinSpanExporter.builder().setSender(sender).setEncoder(spanBytesEncoder).build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={AsyncZipkinSpanHandler.class})
    static class BraveConfiguration {
        BraveConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={Encoding.class})
        @ConditionalOnMissingBean(value={MutableSpan.class}, parameterizedContainer={BytesEncoder.class})
        BytesEncoder<MutableSpan> mutableSpanBytesEncoder(Encoding encoding, ObjectProvider<Tag<Throwable>> throwableTagProvider) {
            Tag throwableTag = (Tag)throwableTagProvider.getIfAvailable(() -> Tags.ERROR);
            return MutableSpanBytesEncoder.create((Encoding)encoding, (Tag)throwableTag);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={BytesMessageSender.class})
        @ConditionalOnEnabledTracing(value="zipkin")
        AsyncZipkinSpanHandler asyncZipkinSpanHandler(BytesMessageSender sender, BytesEncoder<MutableSpan> mutableSpanBytesEncoder) {
            return AsyncZipkinSpanHandler.newBuilder((BytesMessageSender)sender).build(mutableSpanBytesEncoder);
        }
    }
}

