/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.tracing.autoconfigure;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;

class LogCorrelationEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    LogCorrelationEnvironmentPostProcessor() {
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (ClassUtils.isPresent((String)"io.micrometer.tracing.Tracer", (ClassLoader)application.getClassLoader())) {
            environment.getPropertySources().addLast((PropertySource)new LogCorrelationPropertySource(this, (Environment)environment));
        }
    }

    private static class LogCorrelationPropertySource
    extends EnumerablePropertySource<Object> {
        private static final String NAME = "logCorrelation";
        private final Environment environment;

        LogCorrelationPropertySource(Object source, Environment environment) {
            super(NAME, source);
            this.environment = environment;
        }

        public String[] getPropertyNames() {
            return new String[]{"logging.expect-correlation-id"};
        }

        public Object getProperty(String name) {
            if (name.equals("logging.expect-correlation-id")) {
                return this.environment.getProperty("management.tracing.enabled", Boolean.class, (Object)Boolean.TRUE);
            }
            return null;
        }
    }
}

