/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.tomcat.reactive;

import jakarta.servlet.Servlet;
import java.nio.file.Path;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.loader.WebappClassLoaderBase;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.util.scan.StandardJarScanFilter;
import org.springframework.boot.tomcat.ConfigurableTomcatWebServerFactory;
import org.springframework.boot.tomcat.DisableReferenceClearingContextCustomizer;
import org.springframework.boot.tomcat.TomcatEmbeddedContext;
import org.springframework.boot.tomcat.TomcatEmbeddedWebappClassLoader;
import org.springframework.boot.tomcat.TomcatWebServer;
import org.springframework.boot.tomcat.TomcatWebServerFactory;
import org.springframework.boot.web.server.AbstractConfigurableWebServerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.reactive.ConfigurableReactiveWebServerFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.TomcatHttpHandlerAdapter;
import org.springframework.util.ClassUtils;

public class TomcatReactiveWebServerFactory
extends TomcatWebServerFactory
implements ConfigurableTomcatWebServerFactory,
ConfigurableReactiveWebServerFactory {
    public TomcatReactiveWebServerFactory() {
    }

    public TomcatReactiveWebServerFactory(int port) {
        super(port);
    }

    public WebServer getWebServer(HttpHandler httpHandler) {
        AbstractConfigurableWebServerFactory.TempDirs tempDirs = new AbstractConfigurableWebServerFactory.TempDirs(this.getPort());
        Tomcat tomcat = this.createTomcat(tempDirs);
        TomcatHttpHandlerAdapter servlet = new TomcatHttpHandlerAdapter(httpHandler);
        this.prepareContext(tomcat.getHost(), servlet, tempDirs);
        return this.getTomcatWebServer(tomcat);
    }

    @Deprecated(forRemoval=true, since="4.1.0")
    protected void prepareContext(Host host, TomcatHttpHandlerAdapter servlet) {
        this.prepareContext(host, servlet, new AbstractConfigurableWebServerFactory.TempDirs(this.getPort()));
    }

    protected void prepareContext(Host host, TomcatHttpHandlerAdapter servlet, AbstractConfigurableWebServerFactory.TempDirs tempDirs) {
        Path docBase = tempDirs.createTempDir("tomcat-docbase");
        TomcatEmbeddedContext context = new TomcatEmbeddedContext();
        StandardRoot resourceRoot = new StandardRoot((Context)context);
        this.ignoringNoSuchMethodError(() -> TomcatReactiveWebServerFactory.lambda$prepareContext$0((WebResourceRoot)resourceRoot));
        context.setResources((WebResourceRoot)resourceRoot);
        context.setPath("");
        context.setDocBase(docBase.toAbsolutePath().toString());
        context.addLifecycleListener((LifecycleListener)new Tomcat.FixContextListener());
        ClassLoader parentClassLoader = ClassUtils.getDefaultClassLoader();
        context.setParentClassLoader(parentClassLoader);
        this.skipAllTldScanning(context);
        WebappLoader loader = new WebappLoader();
        loader.setLoaderInstance((WebappClassLoaderBase)new TomcatEmbeddedWebappClassLoader(parentClassLoader));
        loader.setDelegate(true);
        context.setLoader((Loader)loader);
        Tomcat.addServlet((Context)context, (String)"httpHandlerServlet", (Servlet)servlet).setAsyncSupported(true);
        context.addServletMappingDecoded("/", "httpHandlerServlet");
        host.addChild((Container)context);
        this.configureContext((Context)context);
    }

    private void ignoringNoSuchMethodError(Runnable method) {
        try {
            method.run();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private void skipAllTldScanning(TomcatEmbeddedContext context) {
        StandardJarScanFilter filter = new StandardJarScanFilter();
        filter.setTldSkip("*.jar");
        context.getJarScanner().setJarScanFilter((JarScanFilter)filter);
    }

    protected void configureContext(Context context) {
        this.getContextLifecycleListeners().forEach(arg_0 -> ((Context)context).addLifecycleListener(arg_0));
        new DisableReferenceClearingContextCustomizer().customize(context);
        this.getContextCustomizers().forEach(customizer -> customizer.customize(context));
    }

    protected TomcatWebServer getTomcatWebServer(Tomcat tomcat) {
        return new TomcatWebServer(tomcat, this.getPort() >= 0, this.getShutdown());
    }

    private static /* synthetic */ void lambda$prepareContext$0(WebResourceRoot resourceRoot) {
        resourceRoot.setReadOnly(true);
    }
}

