/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.tomcat;

import org.apache.catalina.connector.Connector;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.server.Compression;
import org.springframework.util.StringUtils;

public class CompressionConnectorCustomizer
implements TomcatConnectorCustomizer {
    private final @Nullable Compression compression;

    public CompressionConnectorCustomizer(@Nullable Compression compression) {
        this.compression = compression;
    }

    @Override
    public void customize(Connector connector) {
        ProtocolHandler handler;
        if (this.compression != null && this.compression.getEnabled() && (handler = connector.getProtocolHandler()) instanceof AbstractHttp11Protocol) {
            AbstractHttp11Protocol abstractHttp11Protocol = (AbstractHttp11Protocol)handler;
            this.customize(abstractHttp11Protocol, this.compression);
        }
    }

    private void customize(AbstractHttp11Protocol<?> protocol, Compression compression) {
        protocol.setCompression("on");
        protocol.setCompressionMinSize(this.getMinResponseSize(compression));
        protocol.setCompressibleMimeType(this.getMimeTypes(compression));
        if (compression.getExcludedUserAgents() != null) {
            protocol.setNoCompressionUserAgents(this.getExcludedUserAgents(compression));
        }
    }

    private int getMinResponseSize(Compression compression) {
        return (int)compression.getMinResponseSize().toBytes();
    }

    private String getMimeTypes(Compression compression) {
        return StringUtils.arrayToCommaDelimitedString((Object[])compression.getAllMimeTypes());
    }

    private String getExcludedUserAgents(Compression compression) {
        return StringUtils.arrayToCommaDelimitedString((Object[])compression.getExcludedUserAgents());
    }
}

